package csbase.client.applications.flowapplication.actions;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import tecgraf.javautils.gui.GBC;
import csbase.client.algorithms.tasks.OutdatedFlowInfo;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Dilogo para mostrar a lista de algoritmos desatualizados
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class ListOutdatedFlowDialog extends JDialog {

  /** A aplicao */
  FlowApplication app;

  /** Lista de fluxos */
  JList<OutdatedFlowInfo> jList = new JList<OutdatedFlowInfo>();

  /** rea de detalhes */
  JTextArea infoArea = new JTextArea();

  /** Boto de fechar a janela */
  JButton closeButton = new JButton();

  /** Boto de abrir editor de fluxos */
  JButton flowEditorButton = new JButton();

  /**
   * Cosntrutor
   * 
   * @param app A aplicao para i18n e para comandar a seleo de um fluxo
   * @param outdatedFlows Lista de fluxos a serem mostrados
   */
  public ListOutdatedFlowDialog(FlowApplication app,
    Vector<OutdatedFlowInfo> outdatedFlows) {

    addEscListener();
    this.app = app;
    Class<?> myClass = this.getClass();

    jList.setModel(new DefaultComboBoxModel<OutdatedFlowInfo>(outdatedFlows));
    infoArea.setEditable(false);

    JScrollPane listScroll = new JScrollPane(jList);
    JScrollPane infoScroll = new JScrollPane(infoArea);

    setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
    closeButton.setText(app.getClassString(myClass, "close.button"));
    closeButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        closeDialog();
      }
    });

    flowEditorButton.setIcon(ApplicationImages.ICON_FLOW_16);
    flowEditorButton.setToolTipText(app.getClassString(myClass,
      "flow.button.tooltip"));
    flowEditorButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        openFlowEditor();
      }
    });

    JToolBar toolbar = new JToolBar(JToolBar.VERTICAL);
    toolbar.setFloatable(false);
    toolbar.add(flowEditorButton);

    JPanel listPanel = new JPanel(new GridBagLayout());
    listPanel.add(listScroll, new GBC(0, 0).insets(0, 0, 0, 6).both().west());
    listPanel.add(toolbar, new GBC(1, 0).insets(0, 6, 0, 0).vertical()
      .northwest());

    this.setLayout(new GridBagLayout());
    add(new JLabel(app.getClassString(myClass, "outdated.flow.label")),
      new GBC(0, 0).insets(12, 12, 6, 12).horizontal());
    add(listPanel, new GBC(0, 1).insets(6, 12, 12, 12).both().weighty(3));

    add(new JLabel(app.getClassString(myClass, "detail.label")), new GBC(0, 2)
    .insets(12, 12, 6, 12).horizontal());
    add(infoScroll, new GBC(0, 3).insets(6, 12, 6, 12).both().weighty(1));
    add(closeButton, new GBC(0, 4).center().none().insets(6, 12, 12, 12)
      .weighty(1));
    jList.setPreferredSize(new Dimension(400, 400));
    infoArea.setPreferredSize(new Dimension(450, 100));
    Font font = infoArea.getFont();
    infoArea.setFont(new Font("Courier", font.getStyle(), font.getSize()));
    this.setTitle(app.getClassString(myClass, "title"));

    this.pack();
    this.setLocationRelativeTo(app.getApplicationFrame());

    jList.addListSelectionListener(new ListSelectionListener() {
      @Override
      public void valueChanged(ListSelectionEvent e) {
        updateInfoArea();
      }
    });

    if (outdatedFlows.size() > 0) {
      jList.setSelectedIndex(0);
    }

  }

  /**
   * Abre o editor de fluxo
   */
  private void openFlowEditor() {
    OutdatedFlowInfo outdatedFlowInfo = jList.getSelectedValue();
    if (outdatedFlowInfo == null) {
      return;
    }

    if (app.createNewGraph()) {
      app.getWorkspace()
        .addNewNode(outdatedFlowInfo.getFlow().getLastVersion());
    }
  }

  /**
   * fecha o dilogo
   */
  protected void closeDialog() {
    this.dispose();
  }

  /**
   * Atualiza as informaes do fluxo selecionado
   */
  protected void updateInfoArea() {
    OutdatedFlowInfo flow = jList.getSelectedValue();
    if (flow == null) {
      infoArea.setText("");
      return;
    }

    if (flow.getError() != null) {
      infoArea.setText(flow.getError().getMessage());
    }
    else {
      String text = "";

      for (int i = 0; i < flow.getLastVersionNodes().size(); i++) {
        AlgorithmInfo node = flow.getLastVersionNodes().get(i);
        AlgorithmVersionInfo outdatedNode =
          flow.getOutdatedVersionNodes().get(i);
        text +=
          node.getName()
            + "  "
            + app.getClassString(this.getClass(), "can.be.updated",
              new String[] { outdatedNode.toString(),
                  node.getLastVersion().toString() }) + "\n";
      }
      infoArea.setText(text);
    }
  }

  /**
   * Define o contedo do dilogo
   * 
   * @param outdatedFlows Lista de fluxos
   */
  public void setData(Vector<OutdatedFlowInfo> outdatedFlows) {
    this.jList.setModel(new DefaultComboBoxModel<OutdatedFlowInfo>(
      outdatedFlows));

  }

  /**
   * Ajusta a tecla esc para fechar o dilogo.
   */
  private void addEscListener() {
    final AbstractAction cancelAction = new AbstractAction() {
      @Override
      public void actionPerformed(final ActionEvent e) {
        closeDialog();
      }
    };

    final int mode = JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT;
    final InputMap inputMap = rootPane.getInputMap(mode);
    final ActionMap actionMap = rootPane.getActionMap();
    final int esc = KeyEvent.VK_ESCAPE;
    final KeyStroke cancelStroke = KeyStroke.getKeyStroke(esc, 0);
    final String actionMapKey = cancelStroke.toString();
    inputMap.put(cancelStroke, actionMapKey);
    actionMap.put(actionMapKey, cancelAction);
  }
}
