package csbase.client.applications.flowapplication.messages;

import tecgraf.vix.Message;

/**
 * Mensagem utilizada para perguntar se a rea de transferncia est vazia.
 * 
 * @author lmoreira
 */
public final class ClipboardIsEmptyMessage extends Message {

  /**
   * Indica se a rea de transferncia est vazia.
   */
  private Boolean clipboradIsEmpty;

  /**
   * Indica se a rea de transferncia est vazia.
   * 
   * @return {@code true} se estiver vazia, {@code false} se no estiver vazia
   *         ou {@code null} se a informao no foi preenchida.
   */
  public Boolean clipboardIsEmpty() {
    return this.clipboradIsEmpty;
  }

  /**
   * Response a pergunta "A rea de transferncia est vazia?"
   * 
   * @param clipboradIsEmpty Indica se a rea de transferncia est vazia.
   */
  public void setClipboradIsEmpty(final boolean clipboradIsEmpty) {
    this.clipboradIsEmpty = clipboradIsEmpty;
  }
}
