package csbase.client.applications.serverdiagnostic.properties;

import java.awt.Dimension;
import java.awt.GridBagLayout;

import javax.swing.JScrollPane;

import tecgraf.javautils.gui.GBC;
import csbase.client.applications.ApplicationComponentPanel;
import csbase.client.applications.serverdiagnostic.ServerDiagnostic;
import csbase.logic.diagnosticservice.PropertyInfo;

/**
 * Painel que exibe a tabela com as propriedades de configurao do servidor.
 * 
 * @author Tecgraf PUC-Rio
 */
public class PropertiesPanel extends
  ApplicationComponentPanel<ServerDiagnostic> {

  /** As informaes das propriedades exibidas no painel */
  private PropertyInfo[] propertiesInfo;

  /**
   * Construtor
   * 
   * @param propertiesInfo contm as informaes das propriedades de
   *        configurao do servidor.
   * 
   * @param application a aplicao que usa esse painel
   */
  public PropertiesPanel(final ServerDiagnostic application,
    PropertyInfo[] propertiesInfo) {
    super(application);
    this.propertiesInfo = propertiesInfo;
    buildInterface();
  }

  /**
   * Constri os componentes do painel.
   */
  private void buildInterface() {
    PropertiesTable propsTable = new PropertiesTable(propertiesInfo, true);
    setLayout(new GridBagLayout());
    JScrollPane scrollPane = new JScrollPane(propsTable);
    Dimension d = propsTable.getPreferredSize();
    scrollPane.setPreferredSize(new Dimension(d.width, propsTable
      .getRowHeight() * 10));
    add(scrollPane, new GBC(0, 0).both().west().insets(0, 0, 0, 0).weightx(1));
    add(propsTable.getPropertiesDetailPanel(), new GBC(0, 1).horizontal()
      .west().insets(5, 0, 0, 0));
  }

}
