package csbase.client.applications.sgamonitor.actions;

import java.awt.event.ActionEvent;
import java.util.List;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.sgamonitor.SGAMonitor;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.logic.SGASet;

/**
 * Ao que desativa todos os SGAs selecionados.
 * 
 * @author Tecgraf
 */
public class StopSGAClusterAction extends
  AbstractSimpleApplicationAction<SGAMonitor> {

  /**
   * Construtor padro.
   * 
   * @param application - aplicao na qual esta ao est sendo executada.
   */
  public StopSGAClusterAction(SGAMonitor application) {
    super(application, ApplicationImages.ICON_STOP_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    SGAMonitor application = getApplication();
    List<SGASet> selectedSGAs = application.getSelectedSGAs();

    if (confirmShutdown(selectedSGAs)) {
      for (SGASet sga : selectedSGAs) {
        SGAProxy.shutdownSGA(sga.getName());
        sga.setAlive(false);
      }
    }

    application.refreshTables();
  }

  /**
   * Cria a interface que pergunta ao usurio se ele deseja desligar os SGAs.
   * 
   * @param selectedSGAs - SGAs selecionados.
   * @return <code>true</code> se o usurio confirmar, <code>false</code> caso
   *         contrrio.
   */
  private boolean confirmShutdown(List<SGASet> selectedSGAs) {
    Application app = getApplication();
    ApplicationFrame frame = app.getApplicationFrame();

    Object[] options =
      { app.getString("button.stop"), app.getString("button.cancel") };

    String title = app.getString("confirm.view.title");
    String question = app.getString("question.stop.all");

    if (selectedSGAs.size() == 1) {
      SGASet sga = selectedSGAs.get(0);
      question =
        String.format(app.getString("question.stop.one"), sga.getName());
    }

    int opt = StandardDialogs.showOptionDialog(frame, title, question, options);
    return (opt == 0);
  }
}
