package csbase.client.login;

/**
 * Enumera os possveis tipos de mensagens mostradas na tela de login e prov um
 * texto padro para cada um deles.
 */
public enum LoginMessage {
  /**
   * Mensagem de erro nas informaes de login.
   */
  INVALID_LOGIN_INFO("Login ou senha invlidos."),

  /**
   * Mensagem de erro de verso do cliente.
   */
  INVALID_CLIENT_VERSION("<html>As verses do cliente e do servidor so diferentes.<br>Por favor, atualize o cliente.<html>"),

  /**
   * Mensagem de exceo ao tentar fazer o login.
   */
  LOGIN_EXCEPTION("<html>No foi possvel estabelecer conexo. <br>Provavelmente o servidor est fora do ar.<html>"),

  /**
   * Mensagem de campo de usurio vazio.
   */
  EMPTY_LOGIN("Fornea a chave e a senha."),

  /**
   * Mensagem de campo de senha vazio.
   */
  EMPTY_PASSWORD("Fornea a chave e a senha.");

  /**
   * O texto padro que representa a mensagem.
   */
  private String defaultDescription;

  /**
   * Construtor.
   * 
   * @param description O texto padro que representa a mensagem.
   */
  LoginMessage(String description) {
    this.defaultDescription = description;
  }

  /**
   * Obtm o texto padro da mensagem.
   * 
   * @return o texto.
   */
  public String getDefaultDescription() {
    return defaultDescription;
  }
}