package csbase.client.project.action;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.logic.ClientProjectFile;

/**
 * Ao que atualiza um diretrio, sincronizando as informaes mais recentes do
 * servidor (p.ex, incluso/remoo de arquivos).
 * 
 * @author lbarros
 */
public class CommonDirectoryRefreshAction extends CommonProjectAction {
  /** Nome da ao. */
  private static final String ACTION_NAME =
    "CommonDirectoryRefreshAction.action_name";
  /** Mensagem solicitando aguardar a atualizao do diretrio. */
  private static final String UPDATE_MSG =
    "CommonDirectoryRefreshAction.refresh_msg";

  /**
   * Executa a ao.
   * 
   * @param e informaes sobre o evento.
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final ClientProjectFile dir = getSelectedFile();
    if (dir == null || !dir.isDirectory()) {
      return;
    }
    RemoteTask<Void> task = new RemoteTask<Void>() {
      @Override
      public void performTask() throws Exception {
        getProject().refreshDir(dir);
      }
    };
    task.execute(getWindow(), getTitle(), LNG.get(UPDATE_MSG));
  }

  /**
   * Obtm o nome da ao.
   * 
   * @return nome da ao.
   */
  @Override
  public String getName() {
    return LNG.get(ACTION_NAME);
  }

  /**
   * Constri a ao.
   * 
   * @param container referncia para o componente que contm diretrios.
   */
  public CommonDirectoryRefreshAction(ProjectFileContainer container) {
    super(container);
  }
}
