/*
 * $Id: UsersPermissionsTable.java 155512 2014-08-20 18:18:28Z lmachado $
 */
package csbase.client.project.dialogs;

import java.util.List;
import java.util.Set;

import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import tecgraf.javautils.gui.table.SortableTable;
import csbase.logic.UserOutline;

/**
 * Tabela de permissoes de usurios.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class UsersPermissionsTable extends SortableTable {

  /** Flag para indicar se houve alterao nos dados da tabela. */
  private boolean usersPermissionsChanged = false;

  /**
   * Preenche os conjuntos de usurios com acesso RO e com acesso RW definidos
   * na tabela. Os conjuntos so preenchidos independente do tipo de
   * compartilhamento (i.e. mesmo que a tabela esteja desabilitada).
   * 
   * @param usersRO - conjunto de usurios com acesso RO ao projeto, a ser
   *        preenchido pelo mtodo
   * @param usersRW - conjunto de usurios com acesso RW ao projeto, a ser
   *        preenchido pelo mtodo
   */
  public void fillUserSets(final Set<Object> usersRO, final Set<Object> usersRW) {
    final UsersPermissionsTableModel model =
      (UsersPermissionsTableModel) getModel();
    model.fillUserSets(usersRO, usersRW);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setEnabled(final boolean enabled) {
    final int rowCount = getRowCount();
    if (!enabled && rowCount > 0) {
      // De-seleciona todas as linhas se a tabela no est habilitada
      removeRowSelectionInterval(0, rowCount - 1);
    }
    super.setEnabled(enabled);
  }

  /**
   * Construtor.
   * 
   * @param allUsers - todos os usurios do sistema
   * @param usersRO - todos os usurios que tm acesso RO ao projeto
   * @param usersRW - todos os usurios que tm acesso RW ao projeto
   */
  public UsersPermissionsTable(final List<UserOutline> allUsers,
    final Set<Object> usersRO, final Set<Object> usersRW) {
    UsersPermissionsTableModel model =
      new UsersPermissionsTableModel(allUsers, usersRO, usersRW);
    model.addTableModelListener(new TableModelListener() {
      @Override
      public void tableChanged(TableModelEvent e) {
        if (e.getType() == TableModelEvent.UPDATE) {
          usersPermissionsChanged = true;
        }
      }
    });
    setModel(model);
    setRowSelectionAllowed(true);
    // TODO permitir seleo mltipla para operaes com o boto direito
    setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    setUseDisabledLook(true);
  }

  /**
   * Verifica se houve mudanas nas permisses de usurios.
   * 
   * @return True, caso tenham ocorrido mudanas nas permisses de usurios.
   *         False, caso contrrio.
   */
  public boolean hasUsersPermissionsChanged() {
    return usersPermissionsChanged;
  }

  /**
   * Habilita ou desabilita a leitura para todos os usurios: se enable true,
   * todos os valores da coluna RW sero false e da RO sero true e desabilita a
   * edio dessas colunas. Se enable false, desmarca RO e RW e reabilita a
   * edio.
   * 
   * @param enable
   */
  public void enableReadingOnlyForAll(boolean enable) {
    UsersPermissionsTableModel model = (UsersPermissionsTableModel) getModel();
    for (int i = 0; i < model.getRowCount(); i++) {
      model.setReadOnlyFor(enable, i);
    }
    model.enableRORWColumn(!enable);
  }
}
