/**
 * $Id$
 */

package csbase.client.remote.manager.server;

import java.util.Observable;

import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.logic.server.ServerInfoEvent;
import csbase.remote.ServerServiceInterface;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;

/**
 * Representa um observador do {@link ServerServiceInterface servio de
 * servidores}.  responsvel por atualizar e manter caches sincronizados em
 * relao ao repositrio de informaes de servidores do servio.
 * 
 * @author Tecgraf/PUC-Rio
 */
final class ServerServiceRemoteObserver extends Observable {

  /**
   * O ouvinte de mensagens com o corpo contendo objetos da classe
   * AdministrationEvent.
   */
  private IMessageListener listener = new IMessageListener() {
    @Override
    public void onMessagesReceived(Message... messages) throws Exception {
      for (Message message : messages) {
        ServerInfoEvent event = (ServerInfoEvent) message.getBody();
        notifyObservers(event);
      }
    }
  };

  /**
   * Registra no servidor um observador.
   */
  public void install() {
    MessageProxy.addListener(listener, ServerInfoEvent.class);
  }

  /**
   * Remove do servidor o registro desse observador.
   */
  public void uninstall() {
    MessageProxy.removeListener(listener);
  }
}
