/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.actions;

import java.awt.event.ActionEvent;

import csbase.client.algorithms.commands.newview.CommandViewFactory;
import csbase.client.algorithms.commands.newview.NewCommandViewUtils;
import csbase.client.algorithms.commands.view.AlgorithmCommandViewFactory;
import csbase.client.algorithms.commands.view.TabType;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.CommandsMonitor;
import csbase.client.applications.commandsmonitor.events.DoubleClickEvent;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.event.EventListener;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;

/**
 * Mostra os parmetros de um nico comando selecionado.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class ShowCommandParametersAction extends AbstractCommandsAction
  implements EventListener<DoubleClickEvent> {

  /**
   * Construtor.
   * 
   * @param application Aplicao que detm essa ao.
   */
  public ShowCommandParametersAction(CommandsMonitor application) {
    super(application, false, ApplicationImages.ICON_INFORMATION_16);
  }

  /**
   * Filtro indicando que esta ao aceita qualquer comando que no esteja no
   * estado {@link CommandStatus#SCHEDULED agendado} ou no estado
   * {@link CommandStatus#SYSTEM_FAILURE falha no sistema}. {@inheritDoc}
   */
  @Override
  protected boolean accept(CommandInfo command) {
    return command.getStatus() != CommandStatus.SCHEDULED
      && command.getStatus() != CommandStatus.SYSTEM_FAILURE;
  }

  /**
   * Mostra os parmetros do comando selecionado. {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    CommandInfo command = getSelectedCommand();
    showParameters(command);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void eventFired(DoubleClickEvent event) {
    CommandInfo command = event.getClicked();
    if (accept(command)) {
      showParameters(command);
    }
  }

  /**
   * Mostra os parmetros de um comando.
   * 
   * @param command Comando.
   */
  public void showParameters(CommandInfo command) {
    DesktopComponentFrame owner = getApplication().getApplicationFrame();
    try {
      if (NewCommandViewUtils.useNewVersion()) {
        CommandViewFactory.showCommandView(command, owner, NewCommandViewUtils
          .getNewTabType(TabType.PARAMETERS));
      }
      else {
        AlgorithmCommandViewFactory
          .showView(owner, command, TabType.PARAMETERS);
      }
    }
    catch (Exception e) {
      StandardErrorDialogs.showErrorDialog(owner, owner.getTitle(), e);
    }
  }
}
