/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.dal.xml;

import java.util.Hashtable;
import java.util.Map;

import tecgraf.javautils.xml.XMLElementFactory;
import tecgraf.javautils.xml.XMLElementInterface;
import csbase.client.applications.commandsmonitor.dal.xml.elements.ColumnElement;
import csbase.client.applications.commandsmonitor.dal.xml.elements.ColumnReferenceElement;
import csbase.client.applications.commandsmonitor.dal.xml.elements.ColumnsSetElement;
import csbase.client.applications.commandsmonitor.dal.xml.elements.ConfigElement;
import csbase.client.applications.commandsmonitor.dal.xml.elements.ExpressionElement;
import csbase.client.applications.commandsmonitor.dal.xml.elements.FilterElement;
import csbase.client.applications.commandsmonitor.dal.xml.elements.FiltersSetElement;
import csbase.client.applications.commandsmonitor.dal.xml.elements.TabElement;
import csbase.client.applications.commandsmonitor.dal.xml.elements.TabbedPaneElement;
import csbase.client.applications.commandsmonitor.dal.xml.elements.TableElement;
import csbase.client.applications.commandsmonitor.dal.xml.elements.TableReferenceElement;
import csbase.client.applications.commandsmonitor.dal.xml.elements.TablesSetElement;

/**
 * Fbrica de XML da aplicao.
 * 
 * @author Tecgraf
 */
class ConfigElementFactory extends XMLElementFactory {

  /**
   * Mapa
   */
  private Map<String, Class<? extends XMLElementInterface>> _tagsToXMLMap;

  /**
   * Mapa
   */
  private Map<Class<?>, String> _appObjectToTagMap;

  /**
   * Contexto
   */
  private Object _contextObject;

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getAppContextObject() {
    return _contextObject;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setAppContextObject(Object contextObject) {
    _contextObject = contextObject;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void fillConversionTables() {
    mapAppClassToTag(ConfigElement.class, ConfigElement.getTagName());
    mapTagToXMLClass(ConfigElement.getTagName(), ConfigElement.class);

    mapAppClassToTag(ColumnsSetElement.class, ColumnsSetElement.getTagName());
    mapTagToXMLClass(ColumnsSetElement.getTagName(), ColumnsSetElement.class);

    mapAppClassToTag(ColumnElement.class, ColumnElement.getTagName());
    mapTagToXMLClass(ColumnElement.getTagName(), ColumnElement.class);

    mapAppClassToTag(FiltersSetElement.class, FiltersSetElement.getTagName());
    mapTagToXMLClass(FiltersSetElement.getTagName(), FiltersSetElement.class);

    mapAppClassToTag(FilterElement.class, FilterElement.getTagName());
    mapTagToXMLClass(FilterElement.getTagName(), FilterElement.class);

    mapAppClassToTag(ExpressionElement.class, ExpressionElement.getTagName());
    mapTagToXMLClass(ExpressionElement.getTagName(), ExpressionElement.class);

    mapAppClassToTag(TablesSetElement.class, TablesSetElement.getTagName());
    mapTagToXMLClass(TablesSetElement.getTagName(), TablesSetElement.class);

    mapAppClassToTag(TableElement.class, TableElement.getTagName());
    mapTagToXMLClass(TableElement.getTagName(), TableElement.class);

    mapAppClassToTag(ColumnReferenceElement.class,
      ColumnReferenceElement.getTagName());
    mapTagToXMLClass(ColumnReferenceElement.getTagName(),
      ColumnReferenceElement.class);

    mapAppClassToTag(TabbedPaneElement.class, TabbedPaneElement.getTagName());
    mapTagToXMLClass(TabbedPaneElement.getTagName(), TabbedPaneElement.class);

    mapAppClassToTag(TabElement.class, TabElement.getTagName());
    mapTagToXMLClass(TabElement.getTagName(), TabElement.class);

    mapAppClassToTag(TableReferenceElement.class,
      TableReferenceElement.getTagName());
    mapTagToXMLClass(TableReferenceElement.getTagName(),
      TableReferenceElement.class);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<Class<?>, String> getAppObjectToTagMap() {
    if (null == _appObjectToTagMap) {
      _appObjectToTagMap = new Hashtable<Class<?>, String>();
    }
    return _appObjectToTagMap;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<String, Class<? extends XMLElementInterface>> getTagToXMLMap() {
    if (null == _tagsToXMLMap) {
      _tagsToXMLMap =
        new Hashtable<String, Class<? extends XMLElementInterface>>();
    }
    return _tagsToXMLMap;
  }
}
