package csbase.client.applications.projectsmanager.panels.renderers;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;

/**
 * Renderer da coluna de alocao de projetos.
 * 
 * @author jnlopes
 */
public class TableAllocationRenderer extends DefaultTableCellRenderer {

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    final Component component =
      super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
        row, column);
    final JLabel label = (JLabel) component;

    label.setHorizontalAlignment(SwingConstants.CENTER);

    if (value != null) {
      final long allocated = (Long) value;
      if (allocated == 0) {
        label.setText(null);
      }
      else {

        final ProjectSpaceAllocation psa =
          (ProjectSpaceAllocation) table.getValueAt(row, 1);

        if (psa == ProjectSpaceAllocation.WAITING_ALLOCATION) {
          label.setForeground(Color.red);
        }
        else {
          label.setForeground(Color.black);
        }

        label.setText(String.valueOf(allocated) + "gb");
      }
    }
    else {
      label.setText(null);
    }

    return label;
  }
}
