package csbase.client.applications.sgamonitor;

import csbase.client.preferences.annotations.ReadWrite;
import csbase.client.preferences.annotations.Value;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.types.PVTables;

/**
 * Enumerao que define as preferncias da aplicao {@link SGAMonitor}.
 * 
 * @author Tecgraf
 */
enum SGAMonitorPref implements PreferenceDefinition {

  /**
   * Preferncia que armazena a informao de visibilidade de todas as tabelas
   * do frame principal.
   */
  @ReadWrite
  @Value(type = PVTables.class, defaultValue = "")
  MAIN_TABLES,

  /**
   * Preferncia que armazena a informao de visibilidade de todas as tabelas
   * do dilogo de clusters.
   */
  @ReadWrite
  @Value(type = PVTables.class, defaultValue = "")
  CLUSTER_TABLES;

}
