/*
 * $Id: LastPageAction.java 72790 2008-02-15 20:05:47Z clinio $
 */
package csbase.client.util.gui.log.actions;

import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.event.EventListener;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.LogPanel.PagingEvent;
import csbase.client.util.gui.log.actions.core.AbstractLogFileAction;

/**
 * Pede para que o painel de log mostre a ltima pgina. Caso a pgina sendo
 * mostrada pelo painel seja a ltima, esta ao se desabilita.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class LastPageAction extends AbstractLogFileAction {

  /**
   * Construtor
   * 
   * @param logPanel o painel de log associado a ao.
   */
  public LastPageAction(final LogPanel logPanel) {
    super(logPanel, ApplicationImages.ICON_PAGE_LAST_16);
    logPanel.addPagingEventListener(new EventListener<LogPanel.PagingEvent>() {
      public void eventFired(PagingEvent event) {
        long page = event.getPageNumber();
        long pagesCount = event.countPages();
        if (pagesCount <= page) {
          setEnabled(false);
        }
        else {
          setEnabled(true);
        }
      }
    });
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) throws Exception {
    getLogPanel().goToPage(getLogPanel().countPages());
    getLogPanel().getTextArea().goToTail();
  }
}
