/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.panels.tablepanel;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.FileExchangerUI;
import csbase.client.applications.fileexchanger.logic.BlockSize;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeMode;
import csbase.client.applications.fileexchanger.logic.ExchangeState;
import csbase.client.applications.fileexchanger.logic.ExchangeType;
import java.io.File;
import javax.swing.table.AbstractTableModel;

public class TableListModel
extends AbstractTableModel {
    private final FileExchanger fileExchanger;

    @Override
    public final int getColumnCount() {
        return this.fileExchanger.getNumShownColumns();
    }

    @Override
    public final int getRowCount() {
        return this.fileExchanger.getExchangeListSize();
    }

    @Override
    public final Object getValueAt(int row, int column) {
        Exchange exchange = this.fileExchanger.getExchangeItem(row);
        if (exchange == null) {
            return null;
        }
        if (column == 0) {
            ExchangeType type = exchange.getType();
            return type;
        }
        if (column == 1) {
            return exchange;
        }
        if (column == 2) {
            return exchange;
        }
        if (column == 3) {
            double progress = exchange.getProgress();
            Integer n = (int)Math.round(progress * 100.0);
            return n;
        }
        if (column == 4) {
            File localFile = exchange.getLocalFile();
            String path = localFile.getPath();
            return path;
        }
        if (column == 5) {
            return exchange.getRemoteFilePath();
        }
        if (column == 6) {
            long remaining = exchange.getRemainingTime();
            return remaining;
        }
        if (column == 7) {
            long remaining = exchange.getElapsedTime();
            return remaining;
        }
        if (column == 8) {
            if (exchange.getState() == ExchangeState.QUEUED) {
                return 0.0;
            }
            double rate = exchange.getInstantTransferRateMbSec();
            return rate;
        }
        if (column == 9) {
            if (exchange.getState() == ExchangeState.QUEUED) {
                return 0.0;
            }
            double rate = exchange.getGlobalTransferRateMbSec();
            return rate;
        }
        if (column == 10) {
            long size = exchange.getTotalTransferSize();
            return size;
        }
        if (column == 11) {
            return exchange.getTransferMode();
        }
        if (column == 12) {
            return exchange.getBlockSize();
        }
        return exchange;
    }

    @Override
    public final String getColumnName(int col) {
        String tag = "TableListModel." + col + ".column";
        return FileExchangerUI.getString(tag);
    }

    @Override
    public final Class<?> getColumnClass(int column) {
        if (column == 0) {
            return ExchangeType.class;
        }
        if (column == 1) {
            return Exchange.class;
        }
        if (column == 2) {
            return Exchange.class;
        }
        if (column == 3) {
            return Integer.class;
        }
        if (column == 4) {
            return String.class;
        }
        if (column == 5) {
            return String.class;
        }
        if (column == 6) {
            return Long.class;
        }
        if (column == 7) {
            return Long.class;
        }
        if (column == 8) {
            return Double.class;
        }
        if (column == 9) {
            return Double.class;
        }
        if (column == 10) {
            return Long.class;
        }
        if (column == 11) {
            return ExchangeMode.class;
        }
        if (column == 12) {
            return BlockSize.class;
        }
        return Exchange.class;
    }

    @Override
    public final boolean isCellEditable(int row, int col) {
        return false;
    }

    public TableListModel(FileExchanger fileExchanger) {
        this.fileExchanger = fileExchanger;
    }
}

