/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication;

import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import tecgraf.vix.VO;

public final class SVGVO
extends VO {
    private static final int DEFAULT_PADDING = 2;
    private double bottomPadding;
    private double leftPadding;
    private double rightPadding;
    private double topPadding;
    private SVGIcon icon;
    private final Rectangle2D.Double rectangle = new Rectangle2D.Double();
    private final Rectangle2D.Double internalRectangle = new Rectangle2D.Double();
    private VerticalAlignment vAlign = VerticalAlignment.CENTER;
    private HorizontalAlignment hAlign = HorizontalAlignment.CENTER;

    public SVGVO(SVGIcon image) {
        this.icon = new SVGIcon();
        this.icon.setSvgURI(image.getSvgURI());
        this.icon.setScaleToFit(true);
        this.icon.setAntiAlias(true);
        int ih = this.icon.getIconHeight();
        int iw = this.icon.getIconWidth();
        if (ih <= 0 || iw <= 0) {
            this.icon = null;
            ih = 32;
            iw = 32;
            String err = String.format("icon with bad sizes: %d x %d", iw, ih);
            System.out.println(err);
        }
        this.bottomPadding = 2.0;
        this.leftPadding = 2.0;
        this.rightPadding = 2.0;
        this.topPadding = 2.0;
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, iw, ih);
        this.setRectangle(rect);
    }

    public void callbackRepaint(Graphics2D g) {
        if (this.icon == null) {
            g.setColor(Color.red);
            g.draw(this.rectangle);
            return;
        }
        if (this.rectangle.width > 0.0 && this.rectangle.height > 0.0 && this.rectangle.x > 0.0 && this.rectangle.y > 0.0) {
            double shiftX = this.rectangle.width / 2.0;
            double shiftY = this.rectangle.height / 2.0;
            int x = (int)Math.round(this.rectangle.getCenterX() - shiftX);
            int y = (int)Math.round(this.rectangle.getCenterY() - shiftY);
            int width = (int)Math.round(this.rectangle.width);
            int height = (int)Math.round(this.rectangle.height);
            this.icon.setPreferredSize(new Dimension(width, height));
            this.icon.paintIcon(null, (Graphics)g, x, y);
        }
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        rect.setRect(this.rectangle.getX() - this.leftPadding, this.rectangle.getY() - this.topPadding, this.rectangle.getWidth() + this.rightPadding + this.leftPadding, this.rectangle.getHeight() + this.bottomPadding + this.topPadding);
        return rect;
    }

    public void setRectangle(Rectangle2D.Double rect) {
        double x;
        double y;
        double newH;
        double newW;
        this.internalRectangle.setRect(rect.x + this.leftPadding, rect.y + this.topPadding, rect.width - this.rightPadding - this.leftPadding, rect.height - this.bottomPadding - this.topPadding);
        int ih = this.icon.getIconHeight();
        int iw = this.icon.getIconWidth();
        double ir = (double)iw / (double)ih;
        double rh = this.internalRectangle.getHeight();
        double rw = this.internalRectangle.getWidth();
        double rr = rw / rh;
        if (rr < 1.0) {
            newW = rw;
            newH = ir < 1.0 ? rw / ir : newW / ir;
        } else {
            newH = rh;
            newW = ir < 1.0 ? rh * ir : newH * ir;
        }
        switch (this.vAlign) {
            case BOTTOM: {
                y = this.internalRectangle.getY() + rh - newH;
                break;
            }
            case TOP: {
                y = this.internalRectangle.getY();
                break;
            }
            default: {
                y = this.internalRectangle.getCenterY() - newH / 2.0;
            }
        }
        switch (this.hAlign) {
            case LEFT: {
                x = this.internalRectangle.getX();
                break;
            }
            case RIGHT: {
                x = this.internalRectangle.getX() + rw - newW;
                break;
            }
            default: {
                x = this.internalRectangle.getCenterX() - newW / 2.0;
            }
        }
        this.rectangle.setRect(x, y, newW, newH);
    }

    public double getHeight() {
        return this.rectangle.getHeight() + this.bottomPadding + this.topPadding;
    }

    public double getWidth() {
        return this.rectangle.getWidth() + this.leftPadding + this.rightPadding;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.vAlign;
    }

    public void setVerticalAlignment(VerticalAlignment vAlign) {
        this.vAlign = vAlign;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.hAlign;
    }

    public void setHorizontalAlignment(HorizontalAlignment hAlign) {
        this.hAlign = hAlign;
    }

    public double getLeftPadding() {
        return this.leftPadding;
    }

    public double getRightPadding() {
        return this.rightPadding;
    }

    public double getTopPadding() {
        return this.topPadding;
    }

    public void setBottomPadding(double bottomPadding) {
        this.bottomPadding = bottomPadding;
    }

    public void setLeftPadding(double leftPadding) {
        this.leftPadding = leftPadding;
    }

    public void setRightPadding(double rightPadding) {
        this.rightPadding = rightPadding;
    }

    public void setTopPadding(double topPadding) {
        this.topPadding = topPadding;
    }

    public static enum HorizontalAlignment {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static enum VerticalAlignment {
        BOTTOM,
        TOP,
        CENTER;

    }
}

