/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import csbase.client.desktop.RemoteTask;
import csbase.client.util.ClientUtilities;
import csbase.client.util.UserContainerSelection;
import csbase.logic.User;
import csbase.logic.UserOutline;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.selector.ContainerSelectionListener;

public class UsersChooser
extends JDialog {
    private JFrame owner;
    private Vector<UserOutline> selectedUsers;
    private UserContainerSelection containerSelection = null;
    private boolean wasConfirmed;
    protected JButton confirmButton;

    public UsersChooser(JFrame owner, String title, Vector<UserOutline> selectedUsers) {
        super(owner, title, true);
        this.owner = owner;
        this.selectedUsers = selectedUsers;
        this.wasConfirmed = false;
    }

    public void start() {
        JPanel mainPanel = this.createGUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UsersChooser.this.cancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add(mainPanel);
        this.pack();
        ClientUtilities.centerWindow(this, this.owner);
        this.postInitialization();
        this.setVisible(true);
    }

    public JPanel createGUI() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridy = 0;
        JPanel topPanel = this.createOptionalTopPanel();
        if (topPanel != null) {
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.insets = new Insets(5, 10, 0, 10);
            mainPanel.add((Component)topPanel, constraints);
        }
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 10, 0, 10);
        mainPanel.add((Component)this.createSelectablePanel(), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)this.createButtonsPanel(), constraints);
        return mainPanel;
    }

    protected JPanel createOptionalTopPanel() {
        return null;
    }

    private JPanel createSelectablePanel() {
        List<UserOutline> availableUsers = this.retrieveAllUsers();
        for (int i = 0; i < availableUsers.size(); ++i) {
            Object userId = availableUsers.get(i).getId();
            if (!userId.equals(User.getLoggedUser().getId())) continue;
            availableUsers.remove(i);
            break;
        }
        this.containerSelection = new UserContainerSelection(true, new Vector<UserOutline>(availableUsers), this.selectedUsers);
        return this.containerSelection.getPanel();
    }

    private JPanel createButtonsPanel() {
        JPanel panel = new JPanel();
        this.confirmButton = new JButton(LNG.get((String)"UsersChooser.confirm"));
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersChooser.this.confirm();
            }
        });
        this.containerSelection.addContainerSelectionListener(new ContainerSelectionListener(){

            public void containerChanged() {
                UsersChooser.this.confirmButton.setEnabled(true);
            }
        });
        this.confirmButton.setEnabled(false);
        panel.add(this.confirmButton);
        JButton cancelButton = new JButton(LNG.get((String)"UsersChooser.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersChooser.this.cancel();
            }
        });
        panel.add(cancelButton);
        return panel;
    }

    protected void postInitialization() {
    }

    private List<UserOutline> retrieveAllUsers() {
        RemoteTask<List<UserOutline>> task = new RemoteTask<List<UserOutline>>(){

            public void performTask() throws Exception {
                this.setResult(User.getAllOutlines());
            }
        };
        boolean execute = task.execute(this.owner, this.getTitle(), LNG.get((String)"UsersChooser.info.get.users"));
        if (execute) {
            return (List)task.getResult();
        }
        return null;
    }

    public boolean wasConfirmed() {
        return this.wasConfirmed;
    }

    private void confirm() {
        this.wasConfirmed = true;
        this.setVisible(false);
    }

    public Object[] getSelectedUsers() {
        return this.containerSelection.getSelectedItems();
    }

    private void cancel() {
        this.wasConfirmed = false;
        this.setVisible(false);
    }

    public void setEnabledSelectablePanel(boolean enable) {
        this.containerSelection.getContainerSelection().setEnabled(enable);
    }
}

