/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.client.util.table.AbstractCellView;
import csbase.client.util.table.ComboBoxCellViewItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class ComboBoxCellView
extends AbstractCellView {
    private List<ComboBoxCellViewItem> availableItems;
    private JComboBox comboBox;
    private DefaultComboBoxModel comboBoxModel;

    public ComboBoxCellView(List<ComboBoxCellViewItem> availableItems) {
        this.createComboBox();
        this.setAvailableItems(availableItems);
    }

    public void setAvailableItems(List<ComboBoxCellViewItem> availableItems) {
        if (availableItems == null) {
            throw new IllegalArgumentException("O par\u00e2metro availableItems est\u00e1 nulo.");
        }
        this.availableItems = new ArrayList<ComboBoxCellViewItem>(availableItems);
        Collections.sort(this.availableItems);
        this.comboBoxModel.removeAllElements();
        for (ComboBoxCellViewItem item : availableItems) {
            this.comboBoxModel.addElement(item);
        }
    }

    @Override
    public String getTip() {
        ComboBoxCellViewItem item = this.getSelectedItem();
        if (item == null) {
            return null;
        }
        return item.getTip();
    }

    public ComboBoxCellViewItem getSelectedItem() {
        ComboBoxCellViewItem item = (ComboBoxCellViewItem)this.comboBox.getSelectedItem();
        return item;
    }

    @Override
    public Object getValue() {
        ComboBoxCellViewItem item = this.getSelectedItem();
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    @Override
    public JComponent getView() {
        return this.comboBox;
    }

    @Override
    protected void keepValue(Object value) {
        if (value == null) {
            this.comboBoxModel.setSelectedItem(null);
        } else {
            for (ComboBoxCellViewItem item : this.availableItems) {
                if (!item.getValue().equals(value)) continue;
                this.comboBoxModel.setSelectedItem(item);
                return;
            }
            ComboBoxCellViewItem unknownItem = new ComboBoxCellViewItem(value.toString(), null, value);
            unknownItem.setValid(false);
            this.comboBoxModel.setSelectedItem(unknownItem);
        }
    }

    private void createComboBox() {
        this.comboBoxModel = new DefaultComboBoxModel();
        this.comboBox = new JComboBox();
        this.comboBox.setModel(this.comboBoxModel);
        this.comboBox.setRenderer(this.createListCellRenderer());
        this.comboBox.getModel().addListDataListener(this.createListDataListener());
    }

    private ListDataListener createListDataListener() {
        return new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ComboBoxCellViewItem selectedItem = ComboBoxCellView.this.getSelectedItem();
                if (selectedItem != null) {
                    ComboBoxCellView.this.comboBox.setToolTipText(selectedItem.getTip());
                } else {
                    ComboBoxCellView.this.comboBox.setToolTipText(null);
                }
                ComboBoxCellView.this.fireValueWasChanged();
            }
        };
    }

    @Override
    protected String getValidationErrorMessage() {
        if (this.getSelectedItem() == null) {
            return null;
        }
        if (!this.availableItems.contains(this.getSelectedItem())) {
            return String.format("O item %s n\u00e3o est\u00e1 presente na lista de itens v\u00e1lidos (%s).", this.getSelectedItem(), this.availableItems);
        }
        return null;
    }

    private DefaultListCellRenderer createListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ComboBoxCellViewItem item = (ComboBoxCellViewItem)value;
                if (item != null) {
                    this.setText(item.getLabel());
                    if (item.getTip() != null) {
                        this.setToolTipText(item.getTip());
                    }
                }
                return component;
            }
        };
    }
}

