/*
 * Decompiled with CFR 0.152.
 */
package csbase.client;

import csbase.client.ClientLocalFile;
import csbase.client.ClientSmartFileEvent;
import csbase.client.ClientSmartFileFactory;
import csbase.client.desktop.DesktopFrame;
import csbase.exception.project.FileLockedException;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileType;
import csbase.logic.ClientOptimizationMode;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import tecgraf.javautils.core.io.FileUtils;

public class ClientSmartFile
implements ClientFile {
    private ClientOptimizationMode optimizationMode;
    private ClientProjectFile clientProjectFile = null;
    private ClientLocalFile clientLocalFile = null;
    private ClientFile openedFile = null;
    private boolean canReadLocalFile = false;

    public ClientSmartFile(ClientProjectFile cpf, ClientOptimizationMode optimizationMode, String localProjectPath) {
        this.optimizationMode = optimizationMode;
        this.clientProjectFile = cpf;
        if (this.isOptimizedMode()) {
            String filePath = this.buildLocalFilePath(cpf.getPath(), localProjectPath);
            File file = new File(filePath);
            if (!file.exists()) {
                ClientSmartFileFactory.getInstance().notifyListeners(localProjectPath, filePath, ClientSmartFileEvent.OptimizationFailCause.FILE_PATH_NOT_VALID);
                this.optimizationMode = ClientOptimizationMode.NONE;
            } else if (!file.canRead()) {
                ClientSmartFileFactory.getInstance().notifyListeners(localProjectPath, filePath, ClientSmartFileEvent.OptimizationFailCause.CANT_READ_FILE);
                this.optimizationMode = ClientOptimizationMode.NONE;
            } else {
                this.clientLocalFile = new ClientLocalFile(file);
            }
        }
    }

    private CommonClientProject getProject() {
        DesktopFrame dsk = DesktopFrame.getInstance();
        CommonClientProject prj = dsk.getProject();
        return prj;
    }

    public ClientProjectFile getClientProjectFile() {
        return this.clientProjectFile;
    }

    public ClientLocalFile getClientLocalFile() {
        return this.clientLocalFile;
    }

    private String buildLocalFilePath(String[] filePath, String localProjectPath) {
        CommonClientProject project = this.getProject();
        String userAndProjectPath = (String)project.getId();
        userAndProjectPath.replace('/', File.separatorChar);
        StringBuilder strPath = new StringBuilder();
        strPath.append(localProjectPath);
        strPath.append(File.separator);
        strPath.append(userAndProjectPath);
        if (filePath.length > 0) {
            strPath.append(File.separator);
        }
        strPath.append(FileUtils.joinPath((String[])filePath));
        return strPath.toString();
    }

    private boolean isOptimizedMode() {
        return this.optimizationMode == ClientOptimizationMode.GLOBAL;
    }

    public ClientFile[] getChildren() throws Exception {
        ClientProjectFile[] children = this.clientProjectFile.getChildren();
        ClientFile[] smartChildren = new ClientSmartFile[children.length];
        for (int i = 0; i < children.length; ++i) {
            ClientProjectFile child = children[i];
            ClientSmartFile csf = ClientSmartFileFactory.getInstance().create(child);
            smartChildren[i] = csf;
        }
        return smartChildren;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isOptimizedMode()) {
            return this.clientProjectFile.getInputStream();
        }
        try {
            return this.clientLocalFile.getInputStream();
        }
        catch (Exception e) {
            return this.clientProjectFile.getInputStream();
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.isOptimizedMode()) {
            return this.clientProjectFile.getOutputStream();
        }
        try {
            return this.clientLocalFile.getOutputStream();
        }
        catch (Exception e) {
            return this.clientProjectFile.getOutputStream();
        }
    }

    public boolean exists() throws IOException {
        return this.clientProjectFile.exists();
    }

    public long getModificationDate() {
        return this.clientProjectFile.getModificationDate();
    }

    public String getName() {
        return this.clientProjectFile.getName();
    }

    public ClientFile getParent() {
        ClientProjectFile parent = this.clientProjectFile.getParent();
        return ClientSmartFileFactory.getInstance().create(parent);
    }

    public String[] getPath() {
        return this.clientProjectFile.getPath();
    }

    public String getStringPath() {
        return this.clientProjectFile.getStringPath();
    }

    public String getLocalPath() {
        if (this.clientLocalFile != null) {
            return this.clientLocalFile.getStringPath();
        }
        return null;
    }

    public String getType() {
        return this.clientProjectFile.getType();
    }

    public boolean isDirectory() {
        return this.clientProjectFile.isDirectory();
    }

    public boolean canRead() {
        if (!this.isOptimizedMode()) {
            this.canReadLocalFile = false;
            return this.clientProjectFile.canRead();
        }
        try {
            this.canReadLocalFile = true;
            return this.clientLocalFile.canRead();
        }
        catch (Exception e) {
            this.canReadLocalFile = false;
            return this.clientProjectFile.canRead();
        }
    }

    public boolean canWrite() {
        if (!this.isOptimizedMode()) {
            return this.clientProjectFile.canWrite();
        }
        try {
            return this.clientLocalFile.canWrite();
        }
        catch (Exception e) {
            return this.clientProjectFile.canWrite();
        }
    }

    public boolean canExecute() {
        if (!this.isOptimizedMode()) {
            return this.clientProjectFile.canExecute();
        }
        try {
            return this.clientLocalFile.canExecute();
        }
        catch (Exception e) {
            return this.clientProjectFile.canExecute();
        }
    }

    public boolean testOptimization() throws RemoteException {
        boolean ret;
        block4: {
            ret = false;
            if (this.isDirectory()) {
                this.canRead();
                return this.canReadLocalFile;
            }
            try {
                this.open(true);
                if (this.openedFile.getClientFileType() == ClientFileType.LOCAL) {
                    ret = true;
                }
                this.close(true);
            }
            catch (Exception e) {
                System.out.println("Ocorreu erro no teste: " + e.getMessage());
                if (!(e instanceof RemoteException)) break block4;
                throw (RemoteException)e;
            }
        }
        return ret;
    }

    public void open(boolean readOnly) throws Exception {
        if (!this.isOptimizedMode()) {
            this.clientProjectFile.open(readOnly);
            this.openedFile = this.clientProjectFile;
            return;
        }
        try {
            this.clientLocalFile.open(readOnly);
            this.openedFile = this.clientLocalFile;
        }
        catch (Exception e) {
            this.clientProjectFile.open(readOnly);
            this.openedFile = this.clientProjectFile;
        }
    }

    public int read(byte[] dst, long position) throws Exception {
        return this.openedFile.read(dst, position);
    }

    public int read(byte[] dst, int off, int len, long position) throws Exception {
        return this.openedFile.read(dst, off, len, position);
    }

    public void close(boolean force) throws IOException {
        if (this.openedFile == null) {
            return;
        }
        this.openedFile.close(force);
        this.openedFile = null;
    }

    public long size() {
        if (!this.isOptimizedMode()) {
            return this.clientProjectFile.size();
        }
        try {
            return this.clientLocalFile.size();
        }
        catch (Exception e) {
            return this.clientProjectFile.size();
        }
    }

    public ClientFileType getClientFileType() {
        return this.clientProjectFile.getClientFileType();
    }

    public void write(byte[] src, int off, int len, long position) throws IOException, FileLockedException {
        this.openedFile.write(src, off, len, position);
    }

    public void write(byte[] src, long position) throws IOException, FileLockedException {
        this.openedFile.write(src, position);
    }

    public long position() throws IOException {
        return this.openedFile.position();
    }

    public void position(long newPosition) throws IOException {
        this.openedFile.position(newPosition);
    }

    public ClientOptimizationMode getOptimizationMode() {
        return this.optimizationMode;
    }
}

