/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.newview;

import csbase.client.algorithms.parameters.ComponentProperties;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.kernel.ClientException;
import csbase.client.util.gui.log.tab.AbstractTab;
import csbase.logic.CommandInfo;
import csbase.logic.ProgressData;
import csbase.logic.User;
import csbase.logic.algorithms.flows.Flow;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class FlowInfoTab
extends AbstractTab {
    private JScrollPane mainPanel;
    private JProgressBar commandProgress;
    private boolean showProgress;

    public FlowInfoTab(CommandInfo command, Flow flow, boolean showProgress, String title, Window owner) {
        super(AbstractTab.TabType.STATIC, title, owner);
        this.showProgress = showProgress;
        JPanel internalPane = this.createInfoPanel(command, flow);
        this.mainPanel = new JScrollPane(internalPane);
    }

    private JPanel createInfoPanel(CommandInfo command, Flow flow) {
        JPanel internalPane = new JPanel();
        internalPane.setLayout(new GridBagLayout());
        internalPane.add((Component)this.createCommandPanel(command, flow), new GBC().northwest().both().pushy());
        return internalPane;
    }

    private JPanel createCommandPanel(CommandInfo command, Flow flow) {
        JPanel commandPanel = new JPanel();
        commandPanel.setLayout(new GridBagLayout());
        String flowLabel = LNG.get((String)(FlowInfoTab.class.getSimpleName() + ".label.flow.name"));
        JComponent[] flowRow = new JComponent[]{new JLabel(flowLabel), this.createTextField(flow.getName())};
        String idLabel = LNG.get((String)(FlowInfoTab.class.getSimpleName() + ".label.command.id"));
        JComponent[] idRow = new JComponent[]{new JLabel(idLabel), this.createTextField(command.getId())};
        String descLabel = LNG.get((String)(FlowInfoTab.class.getSimpleName() + ".label.command.description"));
        JComponent[] descRow = new JComponent[]{new JLabel(descLabel), this.createTextField(command.getDescription())};
        String userLabel = LNG.get((String)(FlowInfoTab.class.getSimpleName() + ".label.command.user"));
        String userName = null;
        try {
            User user;
            Object userId = command.getUserId();
            if (userId != null && (user = User.getUser((Object)userId)) != null) {
                userName = user.getName();
            }
        }
        catch (Exception e) {
            userName = "---";
        }
        JComponent[] userRow = new JComponent[]{new JLabel(userLabel), this.createTextField(userName)};
        String projLabel = LNG.get((String)(FlowInfoTab.class.getSimpleName() + ".label.command.project"));
        String projectId = command.getProjectId().toString();
        String projectName = projectId.replaceAll("^[/\\\\]?[^/\\\\]+[/\\\\](.*)$", "$1");
        JComponent[] projRow = new JComponent[]{new JLabel(projLabel), this.createTextField(projectName)};
        String dateLabel = LNG.get((String)(FlowInfoTab.class.getSimpleName() + ".label.command.date"));
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy - HH:mm:ss");
        Date date = command.getSubmittedDate();
        String strDate = formatter.format(date);
        JComponent[] dateRow = new JComponent[]{new JLabel(dateLabel), this.createTextField(strDate)};
        String sgaLabel = LNG.get((String)(FlowInfoTab.class.getSimpleName() + ".label.command.sga"));
        JComponent[] sgaRow = new JComponent[]{new JLabel(sgaLabel), this.createTextField(command.getSGAName())};
        if (this.showProgress) {
            String progressLabel = LNG.get((String)(FlowInfoTab.class.getSimpleName() + ".label.command.progress"));
            this.commandProgress = new JProgressBar();
            this.commandProgress.setStringPainted(true);
            this.setProgress(command.getProgressData());
            JComponent[] progressRow = new JComponent[]{new JLabel(progressLabel), this.commandProgress};
            GUIUtils.mountBasicGridPanel((JPanel)commandPanel, (JComponent[][])new JComponent[][]{flowRow, idRow, descRow, userRow, projRow, dateRow, sgaRow, progressRow});
        } else {
            GUIUtils.mountBasicGridPanel((JPanel)commandPanel, (JComponent[][])new JComponent[][]{flowRow, idRow, descRow, userRow, projRow, dateRow, sgaRow});
        }
        return commandPanel;
    }

    private JTextField createTextField(String text) {
        ComponentProperties props = ComponentProperties.getInstance(ParameterView.Mode.REPORT);
        JTextField field = new JTextField();
        field.setText(text);
        field.setEditable(false);
        field.setOpaque(false);
        field.setBorder(props.getBorder());
        return field;
    }

    @Override
    public Component getMainComponent() throws ClientException {
        return this.mainPanel;
    }

    public void setProgress(ProgressData progress) {
        if (this.showProgress) {
            if (progress != null) {
                Double progressValue = progress.getValue();
                this.commandProgress.setValue(progressValue.intValue());
                this.commandProgress.setString(progress.getFormattedValue());
                this.commandProgress.setToolTipText(progress.getDescription());
            } else {
                this.commandProgress.setValue(0);
                this.commandProgress.setString("---");
                this.commandProgress.setToolTipText(null);
            }
        }
    }
}

