/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.algorithms.tasks.OutdatedFlowInfo;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmSelectionPanel;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import tecgraf.javautils.gui.GBC;

public class OutdatedFlowDialog
extends JDialog {
    public static final String CONFIGURATOR_MESSAGE = "CONFIGURATOR_MESSAGE";
    AlgorithmSelectionPanel selectionPanel;
    Application app;
    JList<OutdatedFlowInfo> jList = new JList();
    JTextArea infoArea = new JTextArea();
    JButton closeButton = new JButton();
    JButton sincButton = new JButton();
    JButton flowEditorButton = new JButton();

    public OutdatedFlowDialog(Vector<OutdatedFlowInfo> outdatedFlows, AlgorithmSelectionPanel algorithmSelectionPanel) {
        super(((AlgorithmsManager)algorithmSelectionPanel.getApplication()).getApplicationFrame());
        this.addEscListener();
        this.selectionPanel = algorithmSelectionPanel;
        this.app = algorithmSelectionPanel.getApplication();
        Class<?> myClass = this.getClass();
        this.jList.setModel(new DefaultComboBoxModel<OutdatedFlowInfo>(outdatedFlows));
        this.infoArea.setEditable(false);
        JScrollPane listScroll = new JScrollPane(this.jList);
        JScrollPane infoScroll = new JScrollPane(this.infoArea);
        this.setDefaultCloseOperation(2);
        this.closeButton.setText(this.app.getClassString(myClass, "close.button"));
        this.closeButton.addActionListener(e -> this.closeDialog());
        this.sincButton.setIcon(ApplicationImages.ICON_LINK_16);
        this.sincButton.setToolTipText(this.app.getClassString(myClass, "sinc.button.tooltip"));
        this.sincButton.addActionListener(e -> this.sincSelection());
        this.flowEditorButton.setIcon(ApplicationImages.ICON_FLOW_16);
        this.flowEditorButton.setToolTipText(this.app.getClassString(myClass, "flow.button.tooltip"));
        this.flowEditorButton.addActionListener(e -> this.openFlowEditor());
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        toolbar.add(this.sincButton);
        toolbar.add(this.flowEditorButton);
        JPanel listPanel = new JPanel(new GridBagLayout());
        listPanel.add((Component)listScroll, new GBC(0, 0).insets(0, 0, 0, 6).both().west());
        listPanel.add((Component)toolbar, new GBC(1, 0).insets(0, 6, 0, 0).vertical().northwest());
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(this.app.getClassString(myClass, "outdated.flow.label")), new GBC(0, 0).insets(12, 12, 6, 12).horizontal());
        this.add((Component)listPanel, new GBC(0, 1).insets(6, 12, 12, 12).both().weighty(3.0));
        this.add((Component)new JLabel(this.app.getClassString(myClass, "detail.label")), new GBC(0, 2).insets(12, 12, 6, 12).horizontal());
        this.add((Component)infoScroll, new GBC(0, 3).insets(6, 12, 6, 12).both().weighty(1.0));
        this.add((Component)this.closeButton, new GBC(0, 4).center().none().insets(6, 12, 12, 12).weighty(1.0));
        this.jList.setPreferredSize(new Dimension(400, 400));
        this.infoArea.setPreferredSize(new Dimension(450, 100));
        Font font = this.infoArea.getFont();
        this.infoArea.setFont(new Font("Courier", font.getStyle(), font.getSize()));
        this.setTitle(this.app.getClassString(myClass, "title"));
        this.pack();
        this.setLocationRelativeTo(this.app.getApplicationFrame());
        this.jList.addListSelectionListener(e -> this.updateInfoArea());
        this.jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    OutdatedFlowDialog.this.sincSelection();
                }
            }
        });
        if (outdatedFlows.size() > 0) {
            this.jList.setSelectedIndex(0);
        }
    }

    private void sincSelection() {
        OutdatedFlowInfo info = this.jList.getSelectedValue();
        if (info == null) {
            return;
        }
        if (this.selectionPanel != null) {
            this.selectionPanel.selectAlgorithm(info.getFlow());
        }
    }

    private void openFlowEditor() {
        ApplicationManager am = ApplicationManager.getInstance();
        RemoteTask<FlowAlgorithmConfigurator> task = new RemoteTask<FlowAlgorithmConfigurator>(){

            protected void performTask() throws Exception {
                OutdatedFlowInfo info = OutdatedFlowDialog.this.jList.getSelectedValue();
                FlowAlgorithmConfigurator configurator = (FlowAlgorithmConfigurator)ClientRemoteLocator.algorithmService.createAlgorithmConfigurator(info.getFlow().getName(), info.getFlow().getLastVersion().getId());
                this.setResult(configurator);
            }
        };
        ApplicationFrame window = this.app.getApplicationFrame();
        String title = DesktopFrame.getInstance().getTitle();
        String message = this.app.getClassString(this.getClass(), "creating.configurator");
        try {
            task.execute(window, title, message);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(window, this.app.getClassString(this.getClass(), "error.creating.configurator"), "error.title", -1);
            return;
        }
        FlowAlgorithmConfigurator configurator = (FlowAlgorithmConfigurator)task.getResult();
        try {
            Object app = am.runApplication("flowapplication");
            ((ApplicationType)app).sendMessage(CONFIGURATOR_MESSAGE, configurator, ((ApplicationType)app).getName());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(window, this.app.getClassString(this.getClass(), "error.opening.editor"), "error.title", -1);
            return;
        }
    }

    protected void closeDialog() {
        this.dispose();
    }

    protected void updateInfoArea() {
        OutdatedFlowInfo flow = this.jList.getSelectedValue();
        if (flow == null) {
            this.infoArea.setText("");
            return;
        }
        if (flow.getError() != null) {
            this.infoArea.setText(flow.getError().getMessage());
        } else {
            String text = "";
            for (int i = 0; i < flow.getLastVersionNodes().size(); ++i) {
                AlgorithmInfo node = flow.getLastVersionNodes().get(i);
                AlgorithmVersionInfo outdatedNode = flow.getOutdatedVersionNodes().get(i);
                text = text + node.getName() + "  " + this.app.getClassString(this.getClass(), "can.be.updated", new String[]{outdatedNode.toString(), node.getLastVersion().toString()}) + "\n";
            }
            this.infoArea.setText(text);
        }
    }

    public void setSelectionPanel(AlgorithmSelectionPanel selectionPanel) {
        this.selectionPanel = selectionPanel;
    }

    public void setData(Vector<OutdatedFlowInfo> outdatedFlows, AlgorithmSelectionPanel selectionPanel) {
        this.selectionPanel = selectionPanel;
        this.jList.setModel(new DefaultComboBoxModel<OutdatedFlowInfo>(outdatedFlows));
    }

    private void addEscListener() {
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutdatedFlowDialog.this.closeDialog();
            }
        };
        boolean mode = true;
        InputMap inputMap = this.rootPane.getInputMap(1);
        ActionMap actionMap = this.rootPane.getActionMap();
        int esc = 27;
        KeyStroke cancelStroke = KeyStroke.getKeyStroke(27, 0);
        String actionMapKey = cancelStroke.toString();
        inputMap.put(cancelStroke, actionMapKey);
        actionMap.put(actionMapKey, cancelAction);
    }
}

