/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractVersionTreeNodeAction;
import csbase.client.desktop.LocalTask;
import csbase.client.desktop.RemoteTask;
import csbase.client.desktop.Task;
import csbase.client.externalresources.ExternalResources;
import csbase.client.externalresources.LocalFile;
import csbase.client.externalresources.StandaloneLocalFile;
import csbase.client.externalresources.ZipLocalFile;
import csbase.client.util.ClientUtilities;
import csbase.client.util.SingletonFileChooser;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.CSBaseException;
import csbase.logic.SyncRemoteFileChannel;
import csbase.util.FileSystemUtils;
import csbase.util.Unzip;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public abstract class AbstractImportFileAction
extends AbstractVersionTreeNodeAction {
    private int selectionMode;
    private boolean multiSelectionEnabled;

    public AbstractImportFileAction(VersionTree tree, String name, int selectionMode, boolean multiSelectionEnabled) {
        super(tree, name);
        this.selectionMode = selectionMode;
        this.multiSelectionEnabled = multiSelectionEnabled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (FileSystemUtils.canRead()) {
            this.fileSystemUpload();
        } else {
            this.appletUpload();
        }
    }

    protected abstract void appletUpload();

    protected abstract Task<Boolean> createCheckFileExistenceTask(String var1);

    protected abstract RemoteFileChannelInfo prepareUpload(String var1, boolean var2) throws RemoteException;

    private void fileSystemUpload() {
        File[] sourceFiles = this.getSourceFiles();
        if (!this.validateFiles(sourceFiles)) {
            return;
        }
        LocalFile[] localFiles = this.createLocalFiles(sourceFiles);
        final ArrayList<RequestTransfer> requests = new ArrayList<RequestTransfer>();
        for (LocalFile sourceFile : localFiles) {
            RemoteFileChannelInfo requestInfo = this.getRequestInfo(sourceFile);
            if (requestInfo == null) continue;
            requests.add(new RequestTransfer(sourceFile, requestInfo));
        }
        LocalTask<Void> task = new LocalTask<Void>(){

            protected void performTask() throws Exception {
                for (RequestTransfer request : requests) {
                    request.transfer();
                }
            }

            @Override
            protected void handleError(Exception error) {
                if (error instanceof IOException) {
                    error.printStackTrace();
                    StandardDialogs.showErrorDialog((Component)AbstractImportFileAction.this.getWindow(), (String)AbstractImportFileAction.this.getName(), (String)LNG.get((String)"algomanager.error.upload_fatal"));
                    return;
                }
                super.handleError(error);
            }
        };
        String waitMsg = LNG.get((String)"algomanager.msg.upload_wait");
        task.execute(this.getWindow(), this.getName(), waitMsg, false, true);
    }

    private RemoteFileChannelInfo getRequestInfo(LocalFile file) {
        String waitMsg;
        String fileName;
        final boolean isZipLocalFile = file instanceof ZipLocalFile;
        try {
            fileName = file.getName();
        }
        catch (IOException e) {
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"algomanager.error.upload_io"), e);
            return null;
        }
        Task<Boolean> checkFileExistenceTask = this.createCheckFileExistenceTask(fileName);
        RemoteTask<RemoteFileChannelInfo> prepareUploadTask = new RemoteTask<RemoteFileChannelInfo>(){

            protected void performTask() throws Exception {
                this.setResult(AbstractImportFileAction.this.prepareUpload(fileName, isZipLocalFile));
            }
        };
        if (checkFileExistenceTask != null) {
            waitMsg = LNG.get((String)"algomanager.msg.upload_wait");
            if (!checkFileExistenceTask.execute(this.getWindow(), this.getName(), waitMsg, false, true)) {
                return null;
            }
            if (((Boolean)checkFileExistenceTask.getResult()).booleanValue() && !this.confirmOverwrite(fileName)) {
                return null;
            }
        }
        waitMsg = LNG.get((String)"algomanager.msg.upload_wait");
        if (!prepareUploadTask.execute(this.getWindow(), this.getName(), waitMsg, false, true)) {
            return null;
        }
        return (RemoteFileChannelInfo)prepareUploadTask.getResult();
    }

    private File[] getSourceFiles() {
        SingletonFileChooser chooser = SingletonFileChooser.getInstance();
        chooser.setFileSelectionMode(this.selectionMode);
        chooser.setMultiSelectionEnabled(this.multiSelectionEnabled);
        int returnVal = chooser.showOpenDialog(this.getWindow());
        if (returnVal == 1) {
            return new File[0];
        }
        if (this.multiSelectionEnabled) {
            return chooser.getSelectedFiles();
        }
        return new File[]{chooser.getSelectedFile()};
    }

    private LocalFile[] createLocalFiles(File[] files) {
        try {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                try {
                    String fileName = String.format("%s.zip", file.getParentFile().getName());
                    return new LocalFile[]{new ZipLocalFile(fileName, files)};
                }
                catch (OutOfMemoryError e) {
                    String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal.outOfMemory");
                    StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                    return new LocalFile[0];
                }
                catch (IOException e) {
                    String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal.io");
                    StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                    return new LocalFile[0];
                }
                catch (Exception e) {
                    String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal");
                    StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                    return new LocalFile[0];
                }
            }
            ArrayList<StandaloneLocalFile> sourceFiles = new ArrayList<StandaloneLocalFile>();
            for (File selFile : files) {
                if (selFile == null) continue;
                StandaloneLocalFile standAloneFile = new StandaloneLocalFile(selFile);
                sourceFiles.add(standAloneFile);
            }
            return sourceFiles.toArray(new LocalFile[sourceFiles.size()]);
        }
        catch (AccessControlException ex1) {
            String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal");
            if (!ExternalResources.getInstance().isEnabled()) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg);
                return null;
            }
            try {
                return ExternalResources.getInstance().openMultiFileDialog(".", null);
            }
            catch (CSBaseException ex2) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, ex2);
                return null;
            }
            catch (IOException ex3) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"algomanager.error.upload_io"), ex3);
                return null;
            }
        }
    }

    private boolean confirmOverwrite(String name) {
        String msg = String.format(LNG.get((String)"algomanager.msg.confirm.file_exists"), name);
        int answer = StandardDialogs.showYesNoDialog((Component)this.getWindow(), (String)this.getName(), (Object)msg);
        return answer == 0;
    }

    private boolean validateFiles(File[] files) {
        return 0 < files.length && this.validateFileExists(files) && this.validateZip(files) && this.validateFileName(files);
    }

    private boolean validateZip(File[] files) {
        try {
            for (File file : files) {
                if (!file.getName().toLowerCase().endsWith("zip")) break;
                Unzip unzipped = new Unzip(file);
                List entries = unzipped.listZipEntries();
                for (ZipEntry entry : entries) {
                    String fileName = entry.getName().replaceAll("^(.*/)?([^/]+)/?$", "$2");
                    if (ClientUtilities.isValidFileName(fileName)) continue;
                    StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"UTIL_NAME_CHARACTER_ERROR"));
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"algomanager.error.upload_io"), e);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"UTIL_NAME_CHARACTER_ERROR"));
            return false;
        }
    }

    private boolean validateFileName(File ... files) {
        for (File file : files) {
            if (!ClientUtilities.isValidFileName(file.getName())) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"UTIL_NAME_CHARACTER_ERROR"));
                return false;
            }
            if (!file.isDirectory() || this.validateFileName(file.listFiles())) continue;
            return false;
        }
        return true;
    }

    private boolean validateFileExists(File[] files) {
        ArrayList<File> invalidFiles = new ArrayList<File>();
        for (File file : files) {
            if (file.exists()) continue;
            invalidFiles.add(file);
        }
        if (0 < invalidFiles.size()) {
            StringBuilder invalidFilesList = new StringBuilder();
            for (File file : invalidFiles) {
                invalidFilesList.append(String.format(LNG.get((String)"algomanager.error.upload_files_not_found.files.list"), file.getName()));
            }
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), String.format(LNG.get((String)"algomanager.error.upload_files_not_found"), invalidFilesList.toString()));
            return false;
        }
        return true;
    }

    static class RequestTransfer {
        LocalFile file;
        RemoteFileChannelInfo info;

        RequestTransfer(LocalFile file, RemoteFileChannelInfo info) {
            this.file = file;
            this.info = info;
        }

        void transfer() throws IOException {
            try {
                SyncRemoteFileChannel channel = new SyncRemoteFileChannel(this.info);
                channel.open(false);
                long size = this.file.getLength();
                InputStream source = this.file.getInputStream();
                channel.syncTransferFrom(source, 0L, size);
                source.close();
                channel.setSize(size);
                channel.close();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }
}

