/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractVersionTreeNodeAction;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class RemoveExecutableFiles
extends AbstractVersionTreeNodeAction {
    private final AlgorithmVersionInfo version;
    private final String platform;
    private final FileInfo[] files;

    public RemoveExecutableFiles(VersionTree tree, AlgorithmVersionInfo version, String platform, FileInfo[] files) {
        super(tree, LNG.get((String)"algomanager.menu.bin_file.remove"));
        this.version = version;
        this.platform = platform;
        this.files = files;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new RemoveExecutableDialog().show();
    }

    private class RemoveExecutableDialog {
        private RemoveExecutableDialog() {
        }

        public void show() {
            String dialogTitle = MessageFormat.format(LNG.get((String)"algomanager.title.executable"), RemoveExecutableFiles.this.version.getInfo().getName(), RemoveExecutableFiles.this.version.getId(), RemoveExecutableFiles.this.platform);
            Object[] options = new Object[]{LNG.get((String)"algomanager.button.remove"), LNG.get((String)"algomanager.button.cancel")};
            int opt = StandardDialogs.showOptionDialog((Component)RemoveExecutableFiles.this.getWindow(), (String)dialogTitle, (Object)MessageFormat.format(LNG.get((String)"algomanager.msg.confirm.executable_remove"), FormatUtils.format((Object[])RemoveExecutableFiles.this.files)), (Object[])options);
            if (opt != 0) {
                return;
            }
            boolean success = AlgorithmManagementProxy.removeExecutableFiles(RemoveExecutableFiles.this.version, RemoveExecutableFiles.this.platform, RemoveExecutableFiles.this.files, RemoveExecutableFiles.this.getWindow());
            if (!success) {
                StandardErrorDialogs.showErrorDialog(RemoveExecutableFiles.this.getWindow(), LNG.get((String)"algomanager.title.error") + " - " + dialogTitle, MessageFormat.format(LNG.get((String)"algomanager.error.executable_remove"), FormatUtils.format((Object[])RemoveExecutableFiles.this.files)));
            }
        }
    }
}

