/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.diskinfo;

import csbase.client.applications.Application;
import csbase.client.applications.diskinfo.DiskInfoPanel;
import csbase.client.remote.srvproxies.DiskUsageProxy;
import csbase.logic.diskusageservice.DiskOccupation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.text.NumberFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;
import tecgraf.javautils.core.lng.LNG;

public class DiskSpacePanel
extends DiskInfoPanel {
    private final JFreeChart graph;

    @Override
    public final void rotatePie() {
        PiePlot pieplot = (PiePlot)this.graph.getPlot();
        double angle = pieplot.getStartAngle() + 1.0;
        pieplot.setStartAngle(angle);
        if (angle == 360.0) {
            angle = 0.0;
        }
    }

    @Override
    public final void refreshPie(Application app) {
        DiskOccupation occupation = DiskUsageProxy.getProjectOccupation();
        double free = occupation.getFreeSpaceMb();
        double used = occupation.getUsedSpaceMb();
        PiePlot pieplot = (PiePlot)this.graph.getPlot();
        if (free < 0.0 || used < 0.0) {
            used = 0.0;
            free = 0.0;
        }
        pieplot.setNoDataMessage(app.getString("DiskSpacePanel.get.usage.failed.error"));
        String freeStr = app.getString("panel.space.legend.free");
        String usedStr = app.getString("panel.space.legend.used");
        String labelFmt = app.getString("panel.space.label.format");
        String legendFmt = app.getString("panel.space.legend.format");
        NumberFormat sizeFormatter = NumberFormat.getNumberInstance(LNG.getLocale());
        sizeFormatter.setMinimumFractionDigits(2);
        sizeFormatter.setMaximumFractionDigits(2);
        NumberFormat percFormatter = NumberFormat.getPercentInstance();
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)freeStr), free);
        dataset.setValue((Comparable)((Object)usedStr), used);
        pieplot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(labelFmt, sizeFormatter, percFormatter));
        pieplot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(legendFmt));
        pieplot.setSectionPaint((Comparable)((Object)"0"), (Paint)Color.green.darker());
        pieplot.setSectionPaint((Comparable)((Object)"1"), (Paint)Color.red.darker());
        pieplot.setDirection(Rotation.CLOCKWISE);
        pieplot.setForegroundAlpha(0.7f);
        pieplot.setBackgroundPaint(null);
        pieplot.setOutlinePaint(null);
        pieplot.setCircular(true);
        pieplot.setDataset((PieDataset)dataset);
    }

    public DiskSpacePanel(Application app) {
        String name = app.getString("panel.space.disk");
        String tabName = app.getString("panel.space.disk.tab");
        this.graph = ChartFactory.createPieChart3D((String)name, null, (boolean)true, (boolean)false, (boolean)false);
        ChartPanel chartPanel = new ChartPanel(this.graph);
        chartPanel.setPopupMenu(null);
        this.setLayout(new BorderLayout());
        this.add((Component)chartPanel, "Center");
        this.setName(tabName);
        this.refreshPie(app);
    }
}

