/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.util.AnimatedIcon;
import csbase.logic.ClientProjectFile;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.logic.filetransferservice.FileTransferRequestType;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class FileTransferClientUI {
    private static final String ID = "filetransferclient";
    private static final String FTDIR = "filetypes/";
    private static final String STDIR = "status/";
    public static final ImageIcon FAST_CONNECT_ICON = FileTransferClientUI.buildImageIcon("fast.connect.16.gif");
    public static final ImageIcon REMOTE_ICON = FileTransferClientUI.buildImageIcon("remote.16.gif");
    public static final ImageIcon IMG_TYPE_DIRECTORY = ApplicationImages.ICON_SIMPLE_FOLDER_16;
    public static final ImageIcon IMG_TYPE_FILE = FileTransferClientUI.buildImageIcon("filetypes/file.16.gif");
    public static final ImageIcon IMG_TYPE_LINK = ApplicationImages.ICON_LINK_16;

    private static final ImageIcon buildImageIcon(String path) {
        return FileTransferClient.getImageIcon(FileTransferClient.class, path);
    }

    private static final AnimatedIcon buildAnimatedIcon(String path) {
        ImageIcon imageIcon = FileTransferClientUI.buildImageIcon(path);
        if (imageIcon != null) {
            return new AnimatedIcon(imageIcon);
        }
        return null;
    }

    public static boolean isEmptyString(String str) {
        if (str == null) {
            return true;
        }
        String s = str.trim();
        return s.equals("");
    }

    public static String pathToString(ClientProjectFile prjFile) {
        String[] path = prjFile.getPath();
        int npath = path.length;
        String text = "";
        for (int i = 0; i < npath; ++i) {
            text = text + "/" + path[i];
        }
        return text;
    }

    public static Icon getStatusIcon(FileTransferRequestStatus status) {
        String path = STDIR + status.name() + ".16.gif";
        if (status == FileTransferRequestStatus.RUNNING) {
            return FileTransferClientUI.buildAnimatedIcon(path);
        }
        return FileTransferClientUI.buildImageIcon(path);
    }

    public static Icon getTypeIcon(FileTransferRequestType type) {
        ImageIcon exp = ApplicationImages.ICON_EXPORT_16;
        ImageIcon imp = ApplicationImages.ICON_IMPORT_16;
        return type == FileTransferRequestType.DOWNLOAD ? imp : exp;
    }

    public static String getString(Class<?> clazz, String tag) {
        ApplicationManager mgr = ApplicationManager.getInstance();
        ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
        return reg.getString(clazz.getSimpleName() + "." + tag);
    }

    public static String getStatusTooltip(FileTransferRequestStatus status) {
        String tag = status.toString() + ".tooltip";
        return FileTransferClientUI.getString(FileTransferRequestStatus.class, tag);
    }

    public static String getTypeTooltip(FileTransferRequestType type) {
        String tag = type.toString() + ".tooltip";
        return FileTransferClientUI.getString(FileTransferRequestType.class, tag);
    }

    public static void setEtchedBorder(JComponent component) {
        int BRD_GAP = 5;
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
    }
}

