/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.panels.queuepanel;

import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.logic.filetransferservice.FileTransferRequestType;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class QueueTableModel
extends AbstractTableModel {
    private final String[] colNames;
    private List<FileTransferRequest> list;

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.list == null) {
            return null;
        }
        FileTransferRequest request = this.list.get(row);
        if (column == 0) {
            FileTransferRequestStatus status = request.getStatus();
            return status;
        }
        if (column == 1) {
            FileTransferRequestType type = request.getType();
            return type;
        }
        if (column == 2) {
            FileTransferConnection connection = request.getConnection();
            Object userId = connection.getUserId();
            try {
                User user = User.getUser((Object)userId);
                return user;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (column == 3) {
            return request.getPercentage();
        }
        if (column == 4) {
            String[] localFilePath = request.getLocalFilePath();
            String pth = "";
            for (String s : localFilePath) {
                pth = pth + "/" + s;
            }
            return pth;
        }
        if (column == 5) {
            return request.getTotalBytesSize();
        }
        if (column == 6) {
            return request.getGlobalTransferRateKBytesSec();
        }
        if (column == 7) {
            return request.getQueueTime();
        }
        if (column == 8) {
            return request.getStartTime();
        }
        if (column == 9) {
            return request.getEndTime();
        }
        if (column == 10) {
            return request.getErrorMessage();
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        return this.colNames[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setRequestList(List<FileTransferRequest> list) {
        this.list = list;
        this.fireTableDataChanged();
    }

    public final List<FileTransferRequest> getRequestList() {
        return this.list;
    }

    public QueueTableModel(String[] colNames) {
        this.colNames = colNames;
    }
}

