/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.client.applications.projectsmanager.proxy.SetProjectSharingStatsTask;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.StandardDialogs;

public class SetProjectPublicAction
extends ProjectsManagerAction {
    private ProjectPermissions.SharingType sharingType;

    public SetProjectPublicAction(ProjectsManager projectsManager, boolean readOnly) {
        super(projectsManager);
        this.sharingType = readOnly ? ProjectPermissions.SharingType.ALL_RO : ProjectPermissions.SharingType.ALL_RW;
        this.setRightName();
    }

    private void setRightName() {
        if (this.sharingType == ProjectPermissions.SharingType.ALL_RO) {
            this.putValue("Name", this.getString("SetProjectPublicAction.readonly.name"));
        } else {
            this.putValue("Name", this.getString("SetProjectPublicAction.readwrite.name"));
        }
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() <= 0) {
            return;
        }
        int confirm = StandardDialogs.showYesNoDialog((Component)projectsManager.getApplicationFrame(), (String)this.getString("SetProjectPublicAction.warning.title"), (Object)this.getString("SetProjectPublicAction.warning.msg"));
        if (confirm != 0) {
            return;
        }
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        boolean result = this.runTask(projects);
        if (result) {
            for (ProjectsManagerData pmd : projects) {
                pmd.setSharingType(this.sharingType);
            }
            projectsManager.refreshProjectsTable();
            projectsManager.refreshInfoPanel();
        } else {
            String errMsg = this.getString("SetProjectPublicAction.set.public.error.message");
            String errTitle = this.getString("SetProjectPublicAction.set.public.error.title");
            StandardDialogs.showErrorDialog((Component)projectsManager.getApplicationFrame(), (String)errTitle, (String)errMsg);
        }
    }

    private boolean runTask(List<ProjectsManagerData> projects) throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        SetProjectSharingStatsTask fptt = new SetProjectSharingStatsTask(projectsManager, projects, ProjectsManagerScope.PUBLIC, this.sharingType);
        ApplicationFrame frame = projectsManager.getApplicationFrame();
        fptt.execute(frame, this.getString("SetProjectPublicAction.title"), this.getString("SetProjectPublicAction.message"));
        if (fptt.wasCancelled()) {
            String err = this.getString("SetProjectPublicAction.cancelled.message");
            fptt.showError(err);
            return false;
        }
        if (!fptt.getStatus()) {
            Exception exception = fptt.getError();
            throw exception;
        }
        return (Boolean)fptt.getResult();
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ProjectsManagerScope.PUBLIC.getIcon();
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        String someDeniedMessage;
        int res;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        User loggedUser = User.getLoggedUser();
        Object loggedUserId = loggedUser.getId();
        int i = 0;
        while (i < prjList.size()) {
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
            boolean isAdmin = loggedUser.isAdmin();
            boolean isOwner = pmd.getOwnerId().equals(loggedUserId);
            if (spaceAllocation.isOpenable() && (isAdmin || isOwner)) {
                ++i;
                continue;
            }
            failedProjects.add(pmd);
            prjList.remove(i);
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = this.getString("SetProjectPublicAction.project.selection.denied.message") + this.getString("SetProjectPublicAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("SetProjectPublicAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 && (res = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = this.getString("SetProjectPublicAction.project.selection.some.denied.message") + this.getString("SetProjectPublicAction.project.requirements.message"), prjList, this.getString("SetProjectPublicAction.project.selection.some.failure.message"))) == 0) {
            return null;
        }
        return prjList;
    }
}

