/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.models;

import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlockType;
import csbase.logic.User;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ProjectHistoryBlock {
    private final ProjectHistoryBlockType blockType;
    private List<User> users = null;
    private String userComment;

    public ProjectHistoryBlock(ProjectHistoryBlockType blockType) {
        this.blockType = blockType;
    }

    public String getHistoryBlock() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        User currentUser = User.getLoggedUser();
        StringBuilder blockHeader = new StringBuilder(this.getString("ProjectHistoryBlock.block.header.text"));
        blockHeader.append(" - " + dateFormat.format(date) + "\n");
        blockHeader.append(this.getString("ProjectHistoryBlock.user.text") + " " + currentUser.getName() + " (" + currentUser.getLogin() + ")\n");
        blockHeader.append(this.getBlockTypeString());
        if (this.blockType.equals((Object)ProjectHistoryBlockType.PROJECT_SHARED)) {
            blockHeader.append("\n" + this.getUsersString());
        }
        blockHeader.append("\n\n");
        return blockHeader.toString();
    }

    private String getUsersString() {
        StringBuilder usersString = new StringBuilder();
        if (this.users == null) {
            return "";
        }
        for (User u : this.users) {
            usersString.append(u.getName() + " (" + u.getLogin() + "), ");
        }
        return usersString.substring(0, usersString.length() - 2);
    }

    private String getBlockTypeString() {
        StringBuilder description = new StringBuilder(this.blockType.getDescription());
        if (this.blockType.equals((Object)ProjectHistoryBlockType.PERSONAL_TEXT)) {
            description.append(" " + this.userComment);
        }
        return description.toString();
    }

    private final String getString(String tag) {
        return ProjectsManagerUI.getString(tag);
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public void setUserComment(String userComment) {
        this.userComment = userComment;
    }
}

