/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable.UI;

import csbase.client.facilities.configurabletable.UI.ORIENTATION;
import csbase.client.facilities.configurabletable.UI.UI4Tables;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tecgraf.javautils.gui.GBC;

public class Panel4Tables
extends JPanel
implements UI4Tables {
    private String id;
    private ORIENTATION orientation;
    private List<TableInfo> tables;

    public Panel4Tables(String id, ORIENTATION orientation) {
        super(new GridBagLayout());
        if (id == null) {
            throw new IllegalArgumentException("id n\u00e3o pode ser nulo.");
        }
        if (orientation == null) {
            throw new IllegalArgumentException("orientation n\u00e3o pode ser nulo.");
        }
        this.id = id;
        this.orientation = orientation;
        this.tables = new ArrayList<TableInfo>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public <T> void addTable(ConfigurableTable<?> table, String label, Class<T> dataType) {
        if (table == null) {
            throw new IllegalArgumentException("table n\u00e3o pode ser nulo.");
        }
        if (label == null) {
            throw new IllegalArgumentException("label n\u00e3o pode ser nulo.");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("dataType n\u00e3o pode ser nulo.");
        }
        this.tables.add(new TableInfo(table, label, dataType));
    }

    @Override
    public void buildUI() {
        this.removeAll();
        int xTableIndex = 0;
        int yTableIndex = 0;
        int xLabelIndex = 0;
        int yLabelIndex = 0;
        block3: for (TableInfo info : this.tables) {
            this.add((Component)new JLabel(info.label), new GBC(xLabelIndex, yLabelIndex).west().top(10).left(10).bottom(0));
            yTableIndex = yLabelIndex + 1;
            JScrollPane scroolPane = new JScrollPane((Component)((Object)info.table));
            Dimension dimension = info.table.getPreferredSize();
            info.table.setPreferredSize(null);
            scroolPane.setPreferredSize(dimension);
            this.add((Component)scroolPane, new GBC(xTableIndex, yTableIndex).both().insets(10, 10, 10, 10));
            switch (this.orientation) {
                case HORIZONTAL: 
                case Horizontal: 
                case horizontal: {
                    ++xTableIndex;
                    ++xLabelIndex;
                    continue block3;
                }
            }
            yLabelIndex += 2;
            ++yTableIndex;
        }
    }

    @Override
    public ConfigurableTable<?> getTableById(String tableId) {
        for (TableInfo info : this.tables) {
            if (!info.table.getId().equals(tableId)) continue;
            return info.table;
        }
        return null;
    }

    @Override
    public <T> ConfigurableTable<T> getTableById(String tableId, Class<T> dataType) {
        for (TableInfo info : this.tables) {
            if (!info.table.getId().equals(tableId) || !info.clazz.equals(dataType)) continue;
            return info.table;
        }
        return null;
    }

    @Override
    public List<ConfigurableTable<?>> getAllTables() {
        ArrayList allTables = new ArrayList();
        for (TableInfo info : this.tables) {
            allTables.add(info.table);
        }
        return allTables;
    }

    @Override
    public <T> List<ConfigurableTable<T>> getAllTables(Class<T> dataType) {
        ArrayList<ConfigurableTable<T>> allTables = new ArrayList<ConfigurableTable<T>>();
        for (TableInfo info : this.tables) {
            if (!info.clazz.equals(dataType)) continue;
            allTables.add(info.table);
        }
        return allTables;
    }

    @Override
    public List<ConfigurableTable<?>> getTablesFromSelectedComponent() {
        return this.getAllTables();
    }

    @Override
    public <T> List<ConfigurableTable<T>> getTablesFromSelectedComponent(Class<T> dataType) {
        return this.getAllTables(dataType);
    }

    @Override
    public String getTableLabel(String tableId) {
        for (TableInfo info : this.tables) {
            if (tableId == null || !tableId.equals(info.table.getId())) continue;
            return info.label;
        }
        return null;
    }

    private class TableInfo {
        ConfigurableTable<?> table;
        String label;
        Class<?> clazz;

        public TableInfo(ConfigurableTable<?> table, String label, Class<?> clazz) {
            this.table = table;
            this.label = label;
            this.clazz = clazz;
        }
    }
}

