/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.monitoring;

import csbase.client.facilities.monitoring.DynamicInfoHandler;
import csbase.client.facilities.monitoring.DynamicMonitorPanel;
import csbase.client.facilities.monitoring.StarCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tecgraf.javautils.core.lng.LNG;

public abstract class StarUsagePanel
extends DynamicMonitorPanel {
    private StarCanvas canvasPanel = null;

    public void setCanvasInfoHandler(DynamicInfoHandler infoHandler) {
        this.canvasPanel.setInfoHandler(infoHandler);
    }

    private StarCanvas createCanvasPanel() {
        this.canvasPanel = new StarCanvas();
        this.canvasPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return this.canvasPanel;
    }

    private JPanel createTogglePanel() {
        JPanel togPanel = new JPanel();
        togPanel.setLayout(new GridLayout(3, 2));
        final JCheckBox nameToggle = new JCheckBox(this.getNameToggleLabel(), false);
        nameToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StarUsagePanel.this.canvasPanel.setNameState(nameToggle.isSelected());
            }
        });
        final JCheckBox regionsToggle = new JCheckBox(LNG.get((String)"MON_STAR_REGIONS_TOGGLE"), true);
        regionsToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StarUsagePanel.this.canvasPanel.setRegionsState(regionsToggle.isSelected());
            }
        });
        final JCheckBox radiusToggle = new JCheckBox(LNG.get((String)"MON_STAR_RADIUS_TOGGLE"), false);
        radiusToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StarUsagePanel.this.canvasPanel.setRadiusState(radiusToggle.isSelected());
            }
        });
        final JCheckBox percToggle = new JCheckBox(this.getPercToggleLabel(), false);
        percToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StarUsagePanel.this.canvasPanel.setPercState(percToggle.isSelected());
            }
        });
        final JCheckBox refToggle = new JCheckBox(LNG.get((String)"MON_STAR_REF_TOGGLE"), false);
        refToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StarUsagePanel.this.canvasPanel.setRefState(refToggle.isSelected());
            }
        });
        final JCheckBox scaleToggle = new JCheckBox(LNG.get((String)"MON_STAR_SCALE_TOGGLE"), true);
        scaleToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StarUsagePanel.this.canvasPanel.setScaleState(scaleToggle.isSelected());
            }
        });
        togPanel.add(nameToggle);
        togPanel.add(percToggle);
        togPanel.add(radiusToggle);
        togPanel.add(regionsToggle);
        togPanel.add(refToggle);
        togPanel.add(scaleToggle);
        return togPanel;
    }

    public JSlider createSliderPanel() {
        JSlider factorSlider = new JSlider(1, 1, 10, 1);
        factorSlider.setMajorTickSpacing(1);
        factorSlider.setMinorTickSpacing(1);
        factorSlider.setPaintTicks(true);
        factorSlider.setPaintLabels(true);
        factorSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                StarUsagePanel.this.canvasPanel.setFactor(source.getValue());
            }
        });
        factorSlider.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder(LNG.get((String)"MON_STAR_ZOOM"))));
        return factorSlider;
    }

    public abstract String getNameToggleLabel();

    public abstract String getPercToggleLabel();

    @Override
    public abstract String getTitle();

    public abstract void updateDynamicInfo(Object[] var1);

    public StarUsagePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createCanvasPanel(), "Center");
        this.add((Component)this.createTogglePanel(), "South");
        this.add((Component)this.createSliderPanel(), "West");
    }
}

