/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.project.ProjectTreeNode;
import csbase.logic.ClientProjectFile;
import java.util.Comparator;

public final class ProjectTreeNodeExtensionComparator
implements Comparator<ProjectTreeNode> {
    private static ProjectTreeNodeExtensionComparator instance;

    private ProjectTreeNodeExtensionComparator() {
    }

    public static ProjectTreeNodeExtensionComparator getInstance() {
        if (instance == null) {
            instance = new ProjectTreeNodeExtensionComparator();
        }
        return instance;
    }

    @Override
    public int compare(ProjectTreeNode node1, ProjectTreeNode node2) {
        String ext2;
        boolean d2;
        ClientProjectFile file1 = node1.getClientProjectFile();
        ClientProjectFile file2 = node2.getClientProjectFile();
        boolean d1 = file1.isDirectory();
        if (d1 != (d2 = file2.isDirectory())) {
            if (d1) {
                return -1;
            }
            return 1;
        }
        String ext1 = this.getExtension(file1);
        int comparate = ext1.compareTo(ext2 = this.getExtension(file2));
        if (comparate == 0) {
            String name1 = file1.getName();
            String name2 = file2.getName();
            return name1.compareTo(name2);
        }
        return comparate;
    }

    private String getExtension(ClientProjectFile file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(index + 1);
    }
}

