/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.sga;

import csbase.client.kernel.ClientException;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.client.util.sga.SGASelectionListener;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;

public abstract class SGASelectionPanel
extends JPanel {
    private List<SGASelectionListener> sgaSelectionListeners;
    protected Set<String> platformSet;
    protected Set<String> requirements;
    protected JPanel platformFilterPanel;
    protected JLabel platformFilterLabel;
    protected JComboBox platformFilterComboBox;
    protected String allPlatformsText;
    protected JRadioButton manualServerRadioButton;
    protected JRadioButton automaticServerRadioButton;
    private ButtonGroup serverSelectionButtonGroup;
    protected AlgorithmConfigurator configurator;
    private TitledBorder serverBorder;
    private static final String AUTOMATIC_SELECTION = "automatic.selection";

    protected SGASelectionPanel(AlgorithmConfigurator configurator) {
        this.configurator = configurator;
        this.allPlatformsText = LNG.get((String)"SGASelectionPanel.label.all_platforms");
        this.platformSet = new HashSet<String>();
        this.platformSet.addAll(configurator.getPlatforms());
        this.requirements = new HashSet<String>();
        this.requirements.addAll(configurator.getRequirements());
        this.sgaSelectionListeners = new LinkedList<SGASelectionListener>();
        this.createGUIComponents();
    }

    abstract Collection<SGASet> getManualServerCollection();

    abstract SGASet getManualSelectedServer();

    abstract boolean hasAvailableServers();

    abstract void updateEnabledServers();

    abstract void reloadSGAs();

    public abstract boolean isSelectionReady();

    public abstract void populateGUIComponents();

    public void addSGASelectionListener(SGASelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.sgaSelectionListeners.add(listener);
    }

    public String getSelectedPlatform() {
        return (String)this.platformFilterComboBox.getSelectedItem();
    }

    public Collection<SGASet> getSelectedServerCollection() {
        if (this.isManualServerSelection()) {
            return this.getManualServerCollection();
        }
        return null;
    }

    public SGASet getSelectedServer() {
        return this.getManualSelectedServer();
    }

    protected Vector<SGASet> loadServers() throws ClientException {
        HashMap<String, SGASet> sgaSetMap = new HashMap<String, SGASet>();
        Vector<String> sgaNames = SGAProxy.getAllSGANames();
        if (sgaNames == null) {
            throw new ClientException(LNG.get((String)"SGASelectionPanel.exception.load_sgas"));
        }
        for (String sgaName : sgaNames) {
            SGASet sgaSet = SGAProxy.getSGASet(sgaName);
            sgaSetMap.put(sgaName, sgaSet);
        }
        Vector<String> selectedPlataforms = new Vector<String>();
        String selectedPlatform = this.getPlatformFilter();
        if (selectedPlatform == null) {
            selectedPlataforms.addAll(this.platformSet);
        } else {
            selectedPlataforms.add(selectedPlatform);
        }
        Vector<SGASet> validSGAs = new Vector<SGASet>();
        for (String sgaName : sgaSetMap.keySet()) {
            SGASet sgaSet = (SGASet)sgaSetMap.get(sgaName);
            if (sgaSet == null || !sgaSet.isPlatformSupported(selectedPlataforms) || !sgaSet.hasRequirements(this.requirements) || !sgaSet.mayExecuteCommand()) continue;
            validSGAs.add(sgaSet);
        }
        Collections.sort(validSGAs);
        return validSGAs;
    }

    public void removeSGASelectionListener(SGASelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.sgaSelectionListeners.remove(listener);
    }

    public boolean isManualServerSelection() {
        return this.manualServerRadioButton.isEnabled() && this.manualServerRadioButton.isSelected();
    }

    public String getPlatformFilter() {
        String selectedPlatform = this.getSelectedPlatform();
        if (selectedPlatform.equals(this.allPlatformsText)) {
            return null;
        }
        return selectedPlatform;
    }

    private void createGUIComponents() {
        this.serverBorder = new TitledBorder(BorderFactory.createEtchedBorder(), LNG.get((String)"SGASelectionPanel.label.server"));
        this.platformFilterLabel = new JLabel(LNG.get((String)"SGASelectionPanel.label.platform_filter"));
        this.platformFilterComboBox = this.makePlatformFilterComboBox();
        this.createPlatformFilterPanel();
        boolean automaticSelection = false;
        try {
            Configuration cnf = ConfigurationManager.getInstance().getConfiguration(this.getClass());
            automaticSelection = cnf.getOptionalBooleanProperty(AUTOMATIC_SELECTION, false);
        }
        catch (ConfigurationManagerException e) {
            automaticSelection = false;
        }
        this.manualServerRadioButton = new JRadioButton(LNG.get((String)"SGASelectionPanel.radiobutton.manual_server"));
        this.manualServerRadioButton.setSelected(!automaticSelection);
        this.manualServerRadioButton.addItemListener(new ManualServerRadioButtonItemListener());
        this.manualServerRadioButton.setEnabled(false);
        this.automaticServerRadioButton = new JRadioButton(LNG.get((String)"SGASelectionPanel.radiobutton.automatic_server"));
        this.automaticServerRadioButton.setSelected(automaticSelection);
        this.automaticServerRadioButton.addItemListener(new ManualServerRadioButtonItemListener());
        this.automaticServerRadioButton.setEnabled(false);
        this.serverSelectionButtonGroup = new ButtonGroup();
        this.serverSelectionButtonGroup.add(this.manualServerRadioButton);
        this.serverSelectionButtonGroup.add(this.automaticServerRadioButton);
        this.setBorder(this.serverBorder);
    }

    private void createPlatformFilterPanel() {
        this.platformFilterPanel = new JPanel();
        this.platformFilterPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.platformFilterPanel.add((Component)this.platformFilterLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        this.platformFilterPanel.add((Component)this.platformFilterComboBox, c);
    }

    protected void fireChangedServer() {
        for (SGASelectionListener listener : this.sgaSelectionListeners) {
            listener.wasChangedServer();
        }
    }

    private JComboBox makePlatformFilterComboBox() {
        JComboBox<String> combo = null;
        Vector<String> allPlatforms = new Vector<String>(this.platformSet);
        Collections.sort(allPlatforms);
        allPlatforms.add(0, this.allPlatformsText);
        combo = new JComboBox<String>(allPlatforms);
        combo.setSelectedItem(this.allPlatformsText);
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SGASelectionPanel.this.reloadSGAs();
                SGASelectionPanel.this.fireChangedPlatform();
            }
        });
        return combo;
    }

    protected void fireChangedPlatform() {
        for (SGASelectionListener listener : this.sgaSelectionListeners) {
            listener.wasChangedPlatform();
        }
    }

    private final class ManualServerRadioButtonItemListener
    implements ItemListener {
        private ManualServerRadioButtonItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SGASelectionPanel.this.updateEnabledServers();
            SGASelectionPanel.this.fireChangedServer();
        }
    }
}

