/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.applications.algorithmsmanager.actions.CommonVersionAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.desktop.LocalTask;
import csbase.client.desktop.RemoteTask;
import csbase.client.externalresources.ExternalResources;
import csbase.client.externalresources.LocalFile;
import csbase.client.externalresources.StandaloneLocalFile;
import csbase.client.externalresources.ZipLocalFile;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.SingletonFileChooser;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.CSBaseException;
import csbase.logic.SyncRemoteFileChannel;
import csbase.logic.Utilities;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.util.FileSystemUtils;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class VersionExportAction
extends CommonVersionAction {
    private int selectionMode;

    public VersionExportAction(AlgorithmVersionInfoPanel versionInfoPanel, ImageIcon icon) {
        super(versionInfoPanel, icon);
        this.setSelectionMode(2);
    }

    @Override
    protected void handleVersionOperation() {
        if (this.getSelectedAlgorithm() == null) {
            return;
        }
        if (FileSystemUtils.canRead()) {
            this.fileSystemExport();
        } else {
            this.appletExport();
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    private LocalFile[] createLocalFiles(File[] files) {
        try {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                try {
                    String fileName = String.format("%s.zip", file.getParentFile().getName());
                    return new LocalFile[]{new ZipLocalFile(fileName, files)};
                }
                catch (OutOfMemoryError e) {
                    String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal.outOfMemory");
                    StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                    return new LocalFile[0];
                }
                catch (IOException e) {
                    String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal.io");
                    StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                    return new LocalFile[0];
                }
                catch (Exception e) {
                    String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal");
                    StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                    return new LocalFile[0];
                }
            }
            ArrayList<StandaloneLocalFile> sourceFiles = new ArrayList<StandaloneLocalFile>();
            for (File selFile : files) {
                if (selFile == null) continue;
                StandaloneLocalFile standAloneFile = new StandaloneLocalFile(selFile);
                sourceFiles.add(standAloneFile);
            }
            return sourceFiles.toArray(new LocalFile[sourceFiles.size()]);
        }
        catch (AccessControlException ex1) {
            String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal");
            if (!ExternalResources.getInstance().isEnabled()) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg);
                return null;
            }
            try {
                return ExternalResources.getInstance().openMultiFileDialog(".", null);
            }
            catch (CSBaseException ex2) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, ex2);
                return null;
            }
            catch (IOException ex3) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"algomanager.error.upload_io"), ex3);
                return null;
            }
        }
    }

    protected void appletExport() {
        AlgorithmVersionInfo selectedVersion = this.getSelectedVersion();
        String versionPackName = this.getVersionPackFileName(selectedVersion);
        String filePath = FileUtils.joinPath((char)'/', (String[])new String[]{selectedVersion.getVersionsDirName(), selectedVersion.getDirectory(), selectedVersion.getConfiguratorDirName(), versionPackName});
        String dialogTitle = LNG.get((String)"algomanager.title.config.management");
        this.export(selectedVersion.getInfo().getId(), filePath, dialogTitle);
    }

    private void fileSystemExport() {
        final LocalFile targetFile = this.getTargetFile();
        if (targetFile == null) {
            return;
        }
        if (targetFile.exists() && !this.confirmOverwrite(targetFile)) {
            return;
        }
        String targetFileName = null;
        try {
            targetFileName = targetFile.getName();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        final RemoteFileChannelInfo info = this.getRequestInfo(targetFileName);
        if (info == null) {
            return;
        }
        LocalTask<Void> task = new LocalTask<Void>(){

            protected void performTask() throws Exception {
                SyncRemoteFileChannel channel = new SyncRemoteFileChannel(info);
                channel.open(true);
                long size = channel.getSize();
                OutputStream target = targetFile.getOutputStream(false);
                channel.syncTransferTo(0L, size, target);
                target.flush();
                target.close();
                channel.close();
            }

            @Override
            protected void handleError(Exception error) {
                if (error instanceof IOException) {
                    error.printStackTrace();
                    StandardDialogs.showErrorDialog((Component)VersionExportAction.this.getWindow(), (String)VersionExportAction.this.getName(), (String)LNG.get((String)"algomanager.error.download_fatal"));
                    return;
                }
                super.handleError(error);
            }
        };
        String waitMsg = LNG.get((String)"algomanager.msg.download_wait");
        task.execute(this.getWindow(), this.getName(), waitMsg, false, true);
    }

    private boolean confirmOverwrite(LocalFile targetFile) {
        try {
            String msg = String.format(LNG.get((String)"algomanager.msg.confirm.file_exists"), targetFile.getName());
            int answer = StandardDialogs.showYesNoDialog((Component)this.getWindow(), (String)this.getName(), (Object)msg);
            return answer == 0;
        }
        catch (IOException ex) {
            String msg = LNG.get((String)"algomanager.error.download_io");
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), msg, ex);
            return false;
        }
    }

    private LocalFile getTargetFile() {
        try {
            SingletonFileChooser chooser = SingletonFileChooser.getInstance();
            AlgorithmVersionInfo selectedVersion = this.getSelectedVersion();
            String versionPackName = this.getVersionPackFileName(selectedVersion);
            chooser.setFileSelectionMode(this.getSelectionMode());
            chooser.setMultiSelectionEnabled(false);
            File target = new File(chooser.getCurrentDirectory() + File.separator + versionPackName);
            chooser.setSelectedFile(target);
            int result = chooser.showSaveDialog(this.getWindow());
            if (result == 0) {
                return new StandaloneLocalFile(chooser.getSelectedFile());
            }
            return null;
        }
        catch (AccessControlException ex) {
            return null;
        }
    }

    private String getVersionPackFileName(AlgorithmVersionInfo selectedVersion) {
        return selectedVersion.getInfo().getId() + "_" + selectedVersion.getId() + ".pva";
    }

    private RemoteFileChannelInfo getRequestInfo(final String targetZipFileName) {
        RemoteTask<RemoteFileChannelInfo> task = new RemoteTask<RemoteFileChannelInfo>(){

            protected void performTask() throws Exception {
                this.setResult(VersionExportAction.this.prepareDownload(targetZipFileName));
            }
        };
        String waitMsg = LNG.get((String)"algomanager.msg.upload_wait");
        if (!task.execute(this.getWindow(), this.getName(), waitMsg, false, true)) {
            return null;
        }
        return (RemoteFileChannelInfo)task.getResult();
    }

    protected RemoteFileChannelInfo prepareDownload(String targetZipFileName) throws RemoteException {
        AlgorithmVersionInfo selectedVersion = this.getSelectedVersion();
        String versionPackName = this.getVersionPackFileName(selectedVersion);
        return ClientRemoteLocator.algorithmService.prepareDownloadVersionPackFile((Object)selectedVersion.getInfo().getId(), selectedVersion.getId(), targetZipFileName);
    }

    protected void export(Object algoId, String filePath, String dialogTitle) {
        if (ExternalResources.getInstance().isEnabled()) {
            String[] filePathArray = Utilities.splitProjectPath((String)filePath);
            String urlStr = AlgorithmManagementProxy.retrieveDownloadURL(algoId, filePathArray, this.getWindow());
            if (urlStr == null) {
                return;
            }
            try {
                URL url = new URL(urlStr);
                ExternalResources.getInstance().showDocument(url);
            }
            catch (Exception ex) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), dialogTitle, (Throwable)ex);
            }
        } else {
            StandardDialogs.showInfoDialog((Component)this.getWindow(), (String)dialogTitle, (Object)LNG.get((String)"algomanager.error.download_not_available"));
        }
    }

    static class RequestTransfer {
        LocalFile file;
        RemoteFileChannelInfo info;

        RequestTransfer(LocalFile file, RemoteFileChannelInfo info) {
            this.file = file;
            this.info = info;
        }

        void transfer() throws Exception {
            SyncRemoteFileChannel channel = new SyncRemoteFileChannel(this.info.getIdentifier(), this.info.isWritable(), this.info.getHost(), this.info.getPort(), this.info.getKey());
            channel.open(!this.info.isWritable());
            channel.syncTransferFrom(this.file.getInputStream(), 0L, this.file.getLength());
        }
    }
}

