/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.desktop.DesktopAction;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.LoginAsDialog;
import csbase.client.desktop.LoginAsTask;
import csbase.client.externalresources.ExternalResources;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.remote.srvproxies.PermissionProxy;
import csbase.logic.LoginAsPermission;
import csbase.logic.Permission;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import tecgraf.javautils.core.lng.LNG;

public class LoginAsDesktopAction
extends DesktopAction<DesktopFrame> {
    public static final String REAL_USER_ATTRIBUTE = "realUser";
    private String newLogin;
    private String systemName;
    private String[] availableLogins;

    public LoginAsDesktopAction(String systemName) {
        super(DesktopFrame.getInstance());
        ExternalResources extResources = ExternalResources.getInstance();
        this.availableLogins = this.getAvailableLogins();
        this.setEnabled(extResources.isEnabled());
        this.systemName = systemName;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        LoginAsDialog loginAsDialog = new LoginAsDialog((DesktopFrame)this.getDesktop(), this.availableLogins);
        loginAsDialog.center();
        loginAsDialog.setVisible(true);
        this.newLogin = loginAsDialog.getSelectedNewUser();
        if (this.newLogin != null) {
            this.loginAs();
        }
    }

    private String[] getAvailableLogins() {
        String[] ret = null;
        if (!ClientRemoteMonitor.getInstance().isLoginInfoInitialized()) {
            return null;
        }
        ArrayList retList = new ArrayList();
        Vector<Permission> perms = PermissionProxy.getAllPermissions(((DesktopFrame)this.getDesktop()).getDesktopFrame(), LNG.get((String)"IAS_USER_PERMISSIONS_TITLE"), LNG.get((String)"IAS_WAITING_ALL_PERMISSIONS"));
        for (Permission permission : perms) {
            if (!(permission instanceof LoginAsPermission)) continue;
            LoginAsPermission loginPerm = (LoginAsPermission)permission;
            retList.addAll(loginPerm.getAllowedLogins(ClientRemoteMonitor.getInstance().getLogin()));
        }
        if (!retList.isEmpty()) {
            ret = retList.toArray(new String[retList.size()]);
        }
        return ret;
    }

    public boolean hasAvailableLogins() {
        return this.availableLogins != null;
    }

    protected boolean loginAs() {
        String message;
        String title;
        ExternalResources extResources = ExternalResources.getInstance();
        if (!extResources.isEnabled()) {
            this.showErrorMessage(this.getString("no.external.resources.error"));
            return false;
        }
        LoginAsTask task = new LoginAsTask(this);
        Object desktop = this.getDesktop();
        DesktopComponentFrame frame = ((DesktopFrame)desktop).getDesktopFrame();
        boolean executed = task.execute(frame, title = frame.getTitle(), message = this.getString("task.message"));
        if (!executed) {
            String causeText = "";
            Exception exception = task.getError();
            if (exception != null) {
                causeText = exception.getMessage();
                System.out.println("Erro: " + causeText);
                exception.printStackTrace();
            }
            String tag = "launch.error";
            String err = this.getString("launch.error", causeText);
            this.showErrorMessage(err);
            return false;
        }
        return true;
    }

    public String getNewLogin() {
        return this.newLogin;
    }

    public void setNewLogin(String newLogin) {
        this.newLogin = newLogin;
    }

    public String getSystemName() {
        return this.systemName;
    }
}

