/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectBasicInfo;
import csbase.logic.User;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class OneProjectOpenAction
extends AbstractAction {
    private ProjectBasicInfo projectBasicInfo;

    public OneProjectOpenAction(ProjectBasicInfo projectBasicInfo) {
        this.projectBasicInfo = projectBasicInfo;
        this.putValue("Name", this.buildActionText(projectBasicInfo));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DesktopFrame desktop = DesktopFrame.getInstance();
        if (!desktop.checkOpenableProject(this.projectBasicInfo.getProjectId())) {
            return;
        }
        CommonClientProject project = desktop.openProject(this.projectBasicInfo.getProjectId());
        desktop.setCurrentProject(project);
    }

    private String buildActionText(ProjectBasicInfo projectBasicInfo) {
        String text = projectBasicInfo.getName();
        User user = User.getLoggedUser();
        if (!projectBasicInfo.getUserId().equals(user.getId())) {
            text = text + " (" + projectBasicInfo.getUserLogin() + ")";
        }
        return text;
    }
}

