/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.editors;

import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tecgraf.javautils.gui.GBC;

public class PVDimensionEditor
extends PreferenceEditor<Dimension> {
    public PVDimensionEditor(PreferenceValue<Dimension> pv) {
        super(pv);
    }

    @Override
    protected JComponent createComponent() {
        Dimension dimension = (Dimension)this.getValue();
        final SpinnerNumberModel width = new SpinnerNumberModel(dimension.width, 0, Integer.MAX_VALUE, 1);
        final SpinnerNumberModel height = new SpinnerNumberModel(dimension.height, 0, Integer.MAX_VALUE, 1);
        width.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((Dimension)PVDimensionEditor.this.getValue()).width = (Integer)width.getValue();
                PVDimensionEditor.this.notifyListeners();
            }
        });
        height.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((Dimension)PVDimensionEditor.this.getValue()).height = (Integer)height.getValue();
                PVDimensionEditor.this.notifyListeners();
            }
        });
        JSpinner spinnerWidth = new JSpinner(width);
        spinnerWidth.setEnabled(this.isEditable());
        JSpinner spinnerHeight = new JSpinner(height);
        spinnerWidth.setEnabled(this.isEditable());
        JLabel x = new JLabel("X");
        x.setFont(font);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)spinnerWidth, new GBC(0, 0));
        panel.add((Component)x, new GBC(1, 0).insets(0, 5, 0, 5));
        panel.add((Component)spinnerHeight, new GBC(2, 0));
        return panel;
    }
}

