package csbase.client.applications.algorithmsmanager.report.core;

/**
 * Fbrica de objetos que sero analisados pelos testes.
 */
public interface ISubjectFactory {

  /**
   * Cria o conjunto de objetos a serem analisados.
   *
   * @param test o teste.
   * @param <T> o tipo de objeto esperado pelo teste.
   *
   * @return conjunto de objetos a serem analisados.
   */
  public <T> Iterable<T> createSubject(ITest<T> test);

  /**
   * Adiciona algum para escutar a fbrica
   * 
   * @param listener Aquele que escuta a fbricao
   */
  public void addListener(SourceListener listener);

  /**
   * Remove algum da lista daqueles que escutam a fbrica
   * 
   * @param listener Aquele que escuta a fbricao
   */

  public void removeListener(SourceListener listener);

  /**
   * Avisa da mudana nos dados
   */
  public void callListeners();

}
