/**
 * $Id$
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.logic.ClientAlgorithmFile;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Ao para edio de arquivo texto executvel (script).
 *
 * @author Tecgraf/PUC-Rio
 */
public class EditExecutableFileAction extends AbstractEditionFileAction {

  /** Informaes sobre a verso a qual ser alterada. */
  private AlgorithmVersionInfo version;

  /** Plataforma de origem do arquivo a ser alterado. **/
  private String platform;

  /**
   * Construtor
   *
   * @param tree rvore que detm o n fonte da ao.
   * @param version Verso de origem do arquivo a ser alterado.
   * @param platform Plataforma de origem do arquivo a ser alterado.
   * @param file Arquivo de execuo a ser alterado.
   */
  public EditExecutableFileAction(VersionTree tree,
    AlgorithmVersionInfo version, String platform, FileInfo file) {
    super(tree, LNG.get("algomanager.menu.bin_file.edit"), file);

    this.version = version;
    this.platform = platform;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ClientAlgorithmFile getClientAlgorithmFile(FileInfo info) {
    if (info == null) {
      return null;
    }
    ClientAlgorithmFile file =
      new ClientAlgorithmFile(version.getInfo(), version.getId(), platform,
        info.getName(), info.getPathAsArray(), false);
    return file;
  }
}
