/*
 * $Id: WebViewer.java$
 */
package csbase.client.applications.webviewer;

import java.awt.Window;
import java.net.URL;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.ApplicationProject;
import csbase.client.externalresources.ExternalResources;
import csbase.client.util.StandardErrorDialogs;

/**
 * A classe <code>WebViewer</code> redireciona uma URL para ser aberta no
 * browser.
 *
 * @author Tecgraf/PUC-Rio
 */
public class WebViewer extends ApplicationProject {

  /**
   * Identificador da chave de propriedade: URL.
   */
  private static final String DEFAULT_URL_PROPERTY = "default.url";

  /**
   * {@inheritDoc}
   */
  @Override
  public void postInitialization() throws ApplicationException {
    closeApplication();
  }

  /**
   * Trmino ASAP da aplicao.
   */
  @Override
  public void killApplication() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean userCanKillApplication() {
    return true;
  }

  /**
   * Abre uma URL no browser.
   *
   * @param urlStr a url a ser aberta.
   */
  private void openURL(String urlStr) {
    try {
      final URL url = new URL(urlStr);
      if (ExternalResources.getInstance().isEnabled()) {
        ExternalResources.getInstance().showDocument(url);
        return;
      }
      else {
        throw new Exception(getString("WEB_VIEWER_SERVICE_UNAVAILABLE"));
      }
    }
    catch (Exception e) {
      String msg = getString("WEB_VIEWER_OPEN_URL_ERROR_MESSAGE",
        new Object[] { urlStr, e.getMessage() });
      Window owner = getDesktopFrame().getDesktopFrame();
      String title = getString("WEB_VIEWER_OPEN_URL_ERROR_TITLE");
      StandardErrorDialogs.showErrorDialog(owner, title, msg);
    }
  }

  /**
   * Constri e exibe o dilogo de execuo de algoritmos
   *
   * @param id .
   */
  public WebViewer(final String id) {
    super(id);
    String urlStr = this.getStringSpecificProperty(DEFAULT_URL_PROPERTY);
    openURL(urlStr);
  }
}

