package csbase.client.csdk.v2.extras.user;

import csbase.logic.User;
import csbase.logic.UserOutline;
import csdk.v2.api.user.IUser;
import csdk.v2.api.user.UserException;
import tecgraf.javautils.core.lng.LNG;

/**
 * Encapsula um usurio do sistema em uma interface acessvel pelas aplicaes
 * baseadas no CSDK.
 */
class CSDKUser implements IUser {

  /**
   * Usurio encapsulado.
   */
  private UserOutline user;

  /**
   * {@inheritDoc}
   */
  @Override
  public String getLogin() {
    return user.getLogin();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return user.getName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String[] getEmails() {
    return user.getEmails();
  }

  /**
   * Cria um usurio a partir de um objeto UserOutline.
   * 
   * @param user o usurio
   * 
   */
  public CSDKUser(UserOutline user) {
    this.user = user;
  }

  /**
   * Cria um usurio a partir de um objeto User.
   * 
   * @param user o usurio
   * @throws UserException em caso de erro ao gerar o outline.
   * 
   */
  public CSDKUser(User user) throws UserException {
    try {
      this.user = user.getOutline();
    }
    catch (Exception e) {
      String errorMsg =
        LNG.get(CSDKUserContext.class.getSimpleName() + "user.outline.error",
          new Object[] { user.getLogin() });
      throw new UserException(errorMsg);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isAdmin() {
    return User.isAdmin(user.getId());
  }
}
