/*
 * $Id$
 */

package csbase.client.desktop;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Locale;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.Client;
import csbase.client.externalresources.ExternalResources;
import csbase.client.openbus.OpenBusAccessPoint;
import csbase.exception.CSBaseRuntimeException;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.OpenURLServiceInterface;

/**
 * Ao para clonar o desktop (EXPERIMENTAL - NO USAR).
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CloneDesktopAction extends DesktopAction<DesktopFrame> {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent e) {
    cloneDesktop();
  }

  /**
   * Clonagem.
   * 
   * @return indicativo de sucesso.
   */
  protected boolean cloneDesktop() {
    final ExternalResources extResources = ExternalResources.getInstance();
    if (!extResources.isEnabled()) {
      showErrorMessage("no.external.resources.error");
      return false;
    }

    final CloneTask task = new CloneTask(this);
    final DesktopFrame desktop = getDesktop();
    final DesktopComponentFrame frame = desktop.getDesktopFrame();
    final String title = frame.getTitle();
    final String message = getString("clone.task.message");
    final boolean executed = task.execute(frame, title, message);
    if (!executed) {
      String causeText = "";
      final Exception exception = task.getError();
      if (exception != null) {
        causeText = exception.getMessage();
      }
      final String tag = "clone.launch.error";
      final String err = getString(tag, causeText);
      showErrorMessage(err);
      return false;
    }
    return true;
  }

  /**
   * Construtor
   */
  public CloneDesktopAction() {
    super(DesktopFrame.getInstance());
    final ExternalResources extResources = ExternalResources.getInstance();
    setEnabled(extResources.isEnabled());
  }
}

/**
 * Task remota de clonagem do desktop.
 * 
 * @author Tecgraf/PUC-Rio
 */
class CloneTask extends RemoteTask<Void> {

  /**
   * Ao
   */
  final private CloneDesktopAction action;

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleError(final Exception error) {
    final String message = error.getMessage();
    action.showErrorMessage(message);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleServerError(final CSBaseRuntimeException cserror) {
    final String message = cserror.getMessage();
    action.showErrorMessage(message);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void performTask() throws Exception {
    final OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
    oap.init();
    oap.initSession();

    final OpenBusLoginToken token = oap.getLoginToken();
    final Locale locale = LNG.getLocale();
    final OpenURLServiceInterface openURLService =
      ClientRemoteLocator.openURLService;
    final Client client = Client.getInstance();
    final String myClientId = client.getClientInstanceId();
    final String newClientId = client.generateNewSonId();
    final URL url =
      openURLService.getURL(locale, token, myClientId, newClientId, true);
    final ExternalResources extResources = ExternalResources.getInstance();
    extResources.showDocument(url);
  }

  /**
   * Construtor
   * 
   * @param action ao.
   */
  public CloneTask(final CloneDesktopAction action) {
    this.action = action;
  }
}
