/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.column;

import java.util.Locale;

import javax.swing.table.TableCellRenderer;

import csbase.logic.CommandInfo;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Coluna contendo o percentual de memria RAM utilizada por todos os processos
 * do comando.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class RamColumn extends AbstractCommandsTableColumn {

  /**
   * Construtor.
   * 
   * @param id Identificador da coluna.
   * @param appRegistry registro da aplicao que ser utilizado para se obter o
   *        nome da coluna de acordo com o {@link Locale}.
   */
  public RamColumn(String id, ApplicationRegistry appRegistry) {
    super(Double.class, id, appRegistry);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    return cmd.getRAMMemoryPerc();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return new PercentageTableCellRenderer(getDefaultEmptyValue());
  }
}
