package csbase.client.util.iostring;

/**
 * Interface para acompanhamento da operao de I/O em {@link TextReader} e
 * {@link TextWriter}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface TextDealerStatusInterface {

  /**
   * Callback para informar percentual lido/gravado (intervalo [0,100]). O valor
   * 100 representa o fim da operao e pode ser encarado como uma callback de
   * operao completada.
   * 
   * @param perc percentual executado.
   */
  public void setTextOperationPercentage(int perc);

  /**
   * Callback de consulta para avaliar se o cliente interrompeu a execuo.
   * 
   * @return indicativo.
   */
  public boolean isTextOperationInterrupted();
}
