/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.table.column;

import csbase.client.applications.commandsmonitor.table.column.AbstractCommandsTableColumn;
import csbase.logic.CommandInfo;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import tecgraf.javautils.core.lng.FormatUtils;

public class ElapsedColumn
extends AbstractCommandsTableColumn {
    public ElapsedColumn(String id, ApplicationRegistry appRegistry) {
        super(Double.class, id, appRegistry);
    }

    @Override
    public Object getValue(CommandInfo cmd) {
        return cmd.getWallTimeSec();
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    this.setText(ElapsedColumn.this.getDefaultEmptyValue());
                } else {
                    int wtime = (Integer)value;
                    if (wtime < 0) {
                        this.setText(ElapsedColumn.this.getDefaultErrorValue());
                    } else {
                        String text = FormatUtils.formatInterval((int)wtime);
                        this.setText(text);
                    }
                }
                return this;
            }
        };
    }
}

