/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.multiflow;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.multiflow.CSVPreviewDialog;
import csbase.client.applications.flowapplication.multiflow.ExportMultipleFlowConfigurationDialog;
import csbase.client.applications.flowapplication.multiflow.ImportMultipleFlowConfigurationDialog;
import csbase.client.applications.flowapplication.multiflow.ParameterSelectionDialog;
import csbase.client.applications.flowapplication.multiflow.tree.ParameterSelection;
import csbase.client.util.csvpanel.CSVFileUtils;
import csbase.exception.OperationFailureException;
import csbase.logic.ClientFile;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.NodeParameter;
import java.awt.Dialog;
import java.util.Collections;
import java.util.List;
import tecgraf.javautils.gui.StatusBar;

public class MultiFlowWizard {
    public static final int CONFIG_FILE_HEADER_SIZE = 3;
    private FlowApplication application;
    private ClientFile selectedFile;

    public MultiFlowWizard(FlowApplication application) {
        this.application = application;
    }

    public List<ParameterSelection> chooseExportedParameters(Flow flow) {
        ParameterSelectionDialog dialog = new ParameterSelectionDialog((Application)this.application, flow);
        dialog.setVisible(true);
        if (dialog.isConfirmed()) {
            return dialog.getParameterSelection();
        }
        return Collections.emptyList();
    }

    public ClientFile exportMultipleFlowConfiguration(Flow flow) {
        List<ParameterSelection> parameters;
        if (flow.getName() == null) {
            flow.setName(this.application.getFlowName());
        }
        if ((parameters = this.chooseExportedParameters(flow)) != null && !parameters.isEmpty()) {
            ExportMultipleFlowConfigurationDialog dialog = new ExportMultipleFlowConfigurationDialog(this.application);
            dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dialog.setVisible(true);
            Integer numExecs = dialog.getExecutionNumber();
            ClientFile file = dialog.getConfigurationFile();
            if (dialog.isConfirmed()) {
                String[][] content = this.generateParameterConfigurationTable(parameters, numExecs);
                if (content != null) {
                    try {
                        boolean writeFile = true;
                        if (dialog.showPreview()) {
                            CSVPreviewDialog preview = new CSVPreviewDialog(this.application, file, content, 3);
                            preview.setVisible(true);
                            if (!preview.isConfirmed()) {
                                writeFile = false;
                            }
                        }
                        if (writeFile) {
                            ApplicationFrame applicationFrame = this.application.getApplicationFrame();
                            CSVFileUtils.writeCSVFile(applicationFrame, content, file);
                            StatusBar statusBar = applicationFrame.getStatusBar();
                            statusBar.setInfo(this.application.getString("exportConfigFileSuccess"), 10);
                        }
                    }
                    catch (OperationFailureException e) {
                        this.application.showException(this.application.getString("exportConfigFileError"), e.getCause());
                    }
                } else {
                    this.application.showWarning(this.application.getString("noParametersToExportWarning"));
                }
            }
            return file;
        }
        return null;
    }

    private String[][] generateParameterConfigurationTable(List<ParameterSelection> parameters, int numExecs) {
        int numLines = 3 + numExecs;
        int numColumns = parameters.size();
        String[][] table = new String[numLines][numColumns];
        for (int j = 0; j < numColumns; ++j) {
            ParameterSelection selection = parameters.get(j);
            NodeParameter parameter = selection.parameter;
            FlowNode node = selection.node;
            table[0][j] = node.getAlgorithmName();
            table[1][j] = parameter.getLabel();
            table[2][j] = node.getId() + "." + parameter.getName();
            for (int i = 3; i < numExecs + 3; ++i) {
                table[i][j] = parameter.getValue();
            }
        }
        return table;
    }

    public String[][] importMultipleFlowConfiguration(ClientFile suggestedFile) throws OperationFailureException {
        ImportMultipleFlowConfigurationDialog importDialog = new ImportMultipleFlowConfigurationDialog(this.application, suggestedFile);
        importDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        importDialog.setVisible(true);
        this.selectedFile = importDialog.getConfigurationFile();
        if (importDialog.isConfirmed() && this.selectedFile != null) {
            boolean continueImport = true;
            if (importDialog.showPreview()) {
                CSVPreviewDialog preview = new CSVPreviewDialog(this.application, this.selectedFile, 3);
                preview.setVisible(true);
                if (!preview.isConfirmed()) {
                    continueImport = false;
                }
            }
            if (continueImport) {
                return CSVFileUtils.readCSVFile(this.application.getApplicationFrame(), this.selectedFile);
            }
        }
        return null;
    }

    public String[][] configureMultipleExecution(Flow flow) {
        try {
            String[][] mappings = this.importMultipleFlowConfiguration(this.selectedFile);
            if (mappings != null && mappings.length > 0) {
                mappings = this.removeHeader(mappings, 2);
                return mappings;
            }
        }
        catch (OperationFailureException e) {
            this.application.showException(this.application.getString("importConfigFileError"), e.getCause());
        }
        return null;
    }

    private String[][] removeHeader(String[][] mappings, int num) {
        String[][] newArray = new String[mappings.length - num][];
        System.arraycopy(mappings, num, newArray, 0, mappings.length - num);
        return newArray;
    }
}

