package csbase.client.applicationmanager;

import java.awt.event.ActionEvent;
import java.util.Locale;

import javax.print.attribute.standard.DialogTypeSelection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

import csbase.client.util.StandardErrorDialogs;
import csbase.logic.applicationservice.ApplicationRegistry;
import tecgraf.javautils.gui.StandardDialogs;

/**
 * Ao interna de disparo de aplicativo.
 * 
 * @author Tecgraf/PUC-Rio
 */
final public class ApplicationStartAction extends AbstractAction {

  /**
   * Registry da aplicao.
   */
  final private ApplicationRegistry registry;

  /**
   * Retorna: regstro; conforme atributo {@link #registry}.
   * 
   * @return o valor
   */
  public final ApplicationRegistry getApplicationRegistry() {
    return registry;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent ae) {
    if (!isEnabled()) {
      final String err = "Action perform called and it is inactive!";
      throw new RuntimeException(err);
    }
    final ApplicationManager appManager = ApplicationManager.getInstance();
    try {
      appManager.runApplication(registry.getId());
    }
    catch (Exception e) {
    	// J tratada    	
    }
  }

  /**
   * Construtor.
   * 
   * @param registry reggistro da aplicao.
   * @param locale locale
   */
  ApplicationStartAction(ApplicationRegistry registry, Locale locale) {
    this.registry = registry;
    final String appName = registry.getApplicationName(locale);
    putValue(Action.NAME, appName);

    final byte[] iconDefinition = registry.getIconDefinition();
    if (iconDefinition != null) {
      putValue(Action.SMALL_ICON, new ImageIcon(iconDefinition));
    }
  }
}
