package csbase.client.applications.algorithmsmanager.dialogs;

import java.util.Hashtable;

import javax.swing.JPanel;

import csbase.client.applications.algorithmsmanager.actions.AlgorithmCreateAction;
import csbase.client.applications.algorithmsmanager.actions.CommonEditAction;
import csbase.logic.algorithms.AlgorithmInfo;

/**
 * Essa classe representa um painel para criao de um novo algoritmo.
 * 
 * A criao  enviada para o servidor.
 * 
 */
public class AlgorithmCreateDataPanel extends CommonEditTabbedPanel {
  /** Painel com as informaes bsicas para criao do algoritmo */
  private AlgorithmCreateInfoPanel infoPanel;

  /**
   * Constri o painel para criao de um algoritmo
   * 
   * @param action ao que criou esse painel
   */
  public AlgorithmCreateDataPanel(CommonEditAction action) {
    super(action);
  }

  /**
   * Obtm a ao de criar algoritmo que criou esse painel.
   * 
   * @return a ao de criar algoritmo
   */
  private AlgorithmCreateAction getCreateAction() {
    return (AlgorithmCreateAction) getAction();
  }

  /**
   * Cancela a criao do algoritmo.
   */
  protected void cancel() {
    getCreateAction().cancelCreation();
  }

  /**
   * Cria o algoritmo efetivamente no servidor.
   * 
   * @param algoName nome do algoritmo
   * @param algoId identificador do algoritmo
   * @param fieldValues propriedades do algoritmo
   * 
   * @return o algoritmo criado, ou null, caso tenha ocorrido algum erro
   */
  public AlgorithmInfo createAlgorithm(String algoName, String algoId,
    Hashtable<String, String> fieldValues) {
    return getCreateAction().createAlgorithm(algoName, algoId, fieldValues);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void initializeData() {
    infoPanel.initializeData();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean confirmDataChanged() {
    if (infoPanel.wasModified()) {
      // Confirma o cancelamento das abas alteradas
      return confirmCancelling();
    }
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void buildAdditionalInfoPanel() {
    // No faz nada
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JPanel buildBasicInfoPanel() {
    infoPanel = new AlgorithmCreateInfoPanel(this);
    return infoPanel;
  }

  /**
   * Obtm o painel de seleo de algoritmos.
   * 
   * @return o painel de seleo de algoritmos
   */
  public AlgorithmSelectionPanel getSelectionPanel() {
    return getCreateAction().getSelectionPanel();
  }

}
