package csbase.client.applications.algorithmsmanager.report.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

import csbase.client.applications.Application;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.parameters.ParameterRegistry;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.remote.ClientRemoteLocator;

/**
 * Classe que cria e armazena um conjunto de parameters para ser usado como
 * source de um teste
 *
 * @author Tecgraf/PUC-Rio
 */
@SuppressWarnings("rawtypes")
public class ParameterFactorySource implements Iterable<ParameterFactory> {

  /**
   * Lista de fbricas dos parmetros disponveis.
   */
  private final Collection<ParameterFactory> factories;

  /**
   * Construtor
   *
   * @param app a aplicao
   */
  public ParameterFactorySource(Application app) {
    RemoteTask<Collection<ParameterFactory>> task =
      new RemoteTask<Collection<ParameterFactory>>() {

        @Override
        protected void performTask() throws Exception {
          ParameterRegistry registry = ClientRemoteLocator.algorithmService.getParameterRegistry();
          Map<String, ParameterFactory> factories = registry.getParameterFactories();
          setResult(factories.values());
        }
      };

    task.execute(app.getApplicationFrame(),
      app.getClassString(getClass(), "task.title"),
      app.getClassString(getClass(), "task.description"), true, false);

    if (task.getStatus()) {
      factories = task.getResult();
    }
    else {
      factories = new ArrayList<>();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Iterator<ParameterFactory> iterator() {
    return factories.iterator();
  }

}
