/**
 * $Id$
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.awt.event.ActionEvent;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.applications.Application;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.logic.ClientAlgorithmFile;
import csbase.logic.FileInfo;

/**
 * Ao abstrata de edio de arquivo.
 *
 * @author Tecgraf/PUC-Rio
 */
public abstract class AbstractEditionFileAction extends
  AbstractVersionTreeNodeAction {

  /** Arquivo a ser alterado. */
  private final FileInfo source;

  /**
   * Construtor.
   *
   * @param tree rvore que detm o n fonte da ao.
   * @param name Nome da ao.
   * @param source Arquivo a ser exportado.
   */
  public AbstractEditionFileAction(VersionTree tree, String name,
    FileInfo source) {
    super(tree, name);

    this.source = source;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    openFile(getClientAlgorithmFile(source));
  }

  /**
   * Abre o arquivo no notepad
   *
   * @param file Arquivo da rea de algoritmos
   */
  private void openFile(ClientAlgorithmFile file) {
    if (file == null) {
      return;
    }
    try {
      ApplicationManager am = ApplicationManager.getInstance();
      ApplicationType app = am.runApplication("notepad");
      app.sendMessage(Application.ALGORITHM_FILE_MESSAGE, file, null);
    }
    catch (ApplicationException exception) {
      throw new RuntimeException(exception);
    }
  }

  /**
   * Obtm o arquivo referente ao algoritmo e verso especfica
   *
   * @param info Informaes bsicas para representar um arquivo.
   *
   * @return o arquivo referente ao algoritmo e verso especfica
   */
  protected abstract ClientAlgorithmFile getClientAlgorithmFile(FileInfo info);

}
