/**
 * $Id$
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.logic.ClientAlgorithmFile;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Ao para edio de arquivo texto de configurao.
 *
 * @author Tecgraf/PUC-Rio
 */
public class EditConfigurationFileAction extends AbstractEditionFileAction {

  /** Informaes sobre a verso a qual ser alterada. */
  private AlgorithmVersionInfo version;

  /**
   * Construtor
   *
   * @param tree rvore que detm o n fonte da ao.
   * @param version Verso de origem do arquivo a ser alterado.
   * @param file Arquivo de configurao a ser alterado.
   */
  public EditConfigurationFileAction(VersionTree tree,
    AlgorithmVersionInfo version, FileInfo file) {
    super(tree, LNG.get("algomanager.menu.config.edit"), file);

    this.version = version;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ClientAlgorithmFile getClientAlgorithmFile(FileInfo info) {
    if (info == null) {
      return null;
    }
    ClientAlgorithmFile file =
      new ClientAlgorithmFile(version.getInfo(), version.getId(), info
        .getName(), info.getPathAsArray(),
        ClientAlgorithmFile.AlgorithmFileType.CONFIGURATION, false);
    return file;
  }
}
