package csbase.client.applications.commandsmonitor;

import java.awt.Component;
import java.util.List;

import javax.swing.JTabbedPane;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.commandsmonitor.dal.ITablesTabDAO;
import csbase.client.applications.commandsmonitor.models.TablesTabDTO;
import csbase.client.applications.commandsmonitor.table.CommandsTableFactory;
import csbase.client.util.event.EventManager;
import csbase.client.util.gui.ComponentUtilities;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Painel que contm as abas de tabelas de comando.
 * 
 * @author Tecgraf
 */
public class TablesTabbedPane extends JTabbedPane {

  /**
   * Construtor.
   * 
   * @param tabsDS Informaes do painel de abas.
   * @param tablesFactory Fbrica de tabelas.
   * @param appRegistry Registro da aplicao utilizado para obter a fraseologia
   *        a ser utilizada.
   * @param eventManager gerencia os eventos gerados.
   * 
   * @throws ApplicationException Erro na criao da tabela.
   */
  public TablesTabbedPane(ITablesTabDAO tabsDS,
    CommandsTableFactory tablesFactory, ApplicationRegistry appRegistry,
    EventManager eventManager) throws ApplicationException {

    super();

    addChangeListener(new JTabbedPaneSelectionListener());
    createUI(tabsDS, tablesFactory, appRegistry, eventManager);
  }

  /**
   * Inicializa o monitor de comando de cada tabela presente.
   */
  public void start() {
    Component tab = getSelectedComponent();
    if (null != tab && TablesTab.class.isAssignableFrom(tab.getClass())) {
      TablesTab.class.cast(tab).start();
    }
  }

  /**
   * Interrompe a monitorao de comandos.
   */
  public void stop() {
    for (int inx = 0; inx < getTabCount(); inx++) {
      Component component = getTabComponentAt(inx);
      if (component instanceof TablesTab) {
        TablesTab.class.cast(component).stop();
      }
    }
  }

  /**
   * @param tabsDS
   * @param tablesFactory
   * @param appRegistry
   * @param eventManager
   * @throws ApplicationException
   */
  private void createUI(ITablesTabDAO tabsDS,
    CommandsTableFactory tablesFactory, ApplicationRegistry appRegistry,
    EventManager eventManager) throws ApplicationException {

    // Referncia as abas criadas para posteriormente obter a maior largura dentre elas.
    List<TablesTabDTO> tabsInfo = tabsDS.getTabsInfo();
    TablesTab[] tabs = new TablesTab[tabsInfo.size()];
    for (int inx = 0; inx < tabsInfo.size(); inx++) {
      TablesTabDTO aTabInfo = tabsInfo.get(inx);
      tabs[inx] =
        new TablesTab(aTabInfo, tablesFactory, appRegistry, eventManager);

      // Adiciona a aba a janela.      
      addTab(tabs[inx].getTitle(), tabs[inx]);
      // Verifica se essa  a aba que deve estar inicialmente selecionada.
      if (tabs[inx].getId().equals(tabsDS.getSelectedTabId())) {
        // Seleciona a aba padro de acordo com a configurao.
        setSelectedComponent(tabs[inx]);
      }
    }

    // Atribuia dimenso do painel de abas.
    getPreferredSize().width =
      ComponentUtilities.getMaxPreferredSize(tabs).width + 100;
  }
}
